/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui;

import brachy.modularui.ClientProxy;
import brachy.modularui.CommonProxy;
import brachy.modularui.utils.FormattingUtil;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Mod(value="modularui")
public class ModularUI {
    public static final String MOD_ID = "modularui";
    public static final String NAME = "ModularUI";
    private static final ResourceLocation TEMPLATE_LOCATION = new ResourceLocation("modularui", "");
    public static final Logger LOGGER = LogManager.getLogger((String)"ModularUI");
    private static final RegistryAccess BLANK;
    private static RegistryAccess FROZEN;

    public ModularUI() {
        DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    public static ResourceLocation id(String path) {
        if (path.isBlank()) {
            return TEMPLATE_LOCATION;
        }
        int i = path.indexOf(58);
        if (i > 0) {
            return new ResourceLocation(path);
        }
        if (i == 0) {
            path = path.substring(i + 1);
        }
        if (FormattingUtil.hasUpperCase(path)) {
            path = FormattingUtil.toLowerCaseUnderscore(path);
        }
        return TEMPLATE_LOCATION.m_247449_(path);
    }

    public static boolean isProd() {
        return FMLLoader.isProduction();
    }

    public static boolean isDev() {
        return !ModularUI.isProd();
    }

    public static boolean isDataGen() {
        return FMLLoader.getLaunchHandler().isData();
    }

    public static MinecraftServer getMinecraftServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isClientThread() {
        return ModularUI.isClientSide() && Minecraft.m_91087_().m_18695_();
    }

    public static boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean canGetServerLevel() {
        if (ModularUI.isClientSide()) {
            return Minecraft.m_91087_().f_91073_ != null;
        }
        MinecraftServer server = ModularUI.getMinecraftServer();
        return server != null && !server.m_129918_() && !server.m_129782_() && server.m_130010_() && !server.m_195518_();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @ApiStatus.Internal
    public static void updateFrozenRegistry(RegistryAccess registryAccess) {
        FROZEN = registryAccess;
    }

    public static RegistryAccess builtinRegistry() {
        if (ModularUI.isClientThread()) {
            return ClientHelpers.getClientRegistries();
        }
        return FROZEN;
    }

    static {
        FROZEN = BLANK = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
    }

    private static class ClientHelpers {
        private ClientHelpers() {
        }

        private static RegistryAccess getClientRegistries() {
            if (Minecraft.m_91087_().m_91403_() != null) {
                return Minecraft.m_91087_().m_91403_().m_105152_();
            }
            return FROZEN;
        }
    }

    public static class ModIds {
        public static final String BLUR = "blur";
        public static final String BOGOSORTER = "bogosorter";
        public static final String CURIOS = "curios";
        public static final String EMI = "emi";
        public static final String JEI = "jei";
        public static final String REI = "roughlyenoughitems";
        public static final String KUBEJS = "kubejs";
        public static final String MODNAMETOOLTIP = "modnametooltip";
        public static final String NEA = "neverenoughanimations";
        public static final String IRIS = "iris";
        public static final String OCULUS = "oculus";
        public static final String SODIUM = "sodium";
        public static final String EMBEDDIUM = "embeddium";
    }

    public static enum Mods {
        CURIOS("curios"),
        EMI("emi"),
        JEI("jei"),
        REI("roughlyenoughitems"),
        KUBEJS("kubejs"),
        EMBEDDIUM("embeddium"),
        SODIUM("sodium"),
        IRIS("iris"),
        OCULUS("oculus");

        public final String id;
        private boolean loaded = false;
        private boolean initialized = false;
        private final Predicate<ModContainer> extraLoadedCheck;

        public static boolean isSodiumLikeLoaded() {
            return SODIUM.isLoaded() || EMBEDDIUM.isLoaded();
        }

        public static boolean isIrisLikeLoaded() {
            return IRIS.isLoaded() || OCULUS.isLoaded();
        }

        public static boolean isRecipeViewerLoaded() {
            return JEI.isLoaded() || EMI.isLoaded() || REI.isLoaded();
        }

        private Mods(String id) {
            this(id, null);
        }

        private Mods(String id, Predicate<ModContainer> extraLoadedCheck) {
            this.id = id;
            this.extraLoadedCheck = extraLoadedCheck;
        }

        public boolean isLoaded() {
            if (!this.initialized) {
                this.loaded = ModList.get().isLoaded(this.id);
                if (this.loaded && this.extraLoadedCheck != null) {
                    this.loaded = this.extraLoadedCheck.test((ModContainer)ModList.get().getModContainerById(this.id).orElseThrow());
                }
                this.initialized = true;
            }
            return this.loaded;
        }
    }
}

