/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui;

import brachy.modularui.GuiErrorHandler;
import brachy.modularui.ModularUI;
import brachy.modularui.api.widget.IWidget;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.Level;

public class GuiError {
    private final Level level = Level.ERROR;
    private final String msg;
    private final IWidget reference;
    private final Type type;

    public static void throwNew(IWidget guiElement, Type type, String msg) {
        if (ModularUI.isClientSide()) {
            GuiErrorHandler.INSTANCE.pushError(guiElement, type, msg);
        }
    }

    protected GuiError(String msg, IWidget reference, Type type) {
        this.msg = msg;
        this.reference = reference;
        this.type = type;
    }

    public String toString() {
        return "MUI [" + this.type.toString() + "][" + this.reference.toString() + "]: " + this.msg;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.reference, this.type});
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public IWidget getReference() {
        return this.reference;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    public static enum Type {
        DRAW,
        SIZING,
        WIDGET_TREE,
        INTERACTION,
        SYNC;

    }
}

