/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui;

import brachy.modularui.ModularUI;
import brachy.modularui.ModularUIConfig;
import brachy.modularui.ModularUIMenuTypes;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.factory.UIFactories;
import brachy.modularui.factory.inventory.InventoryTypes;
import brachy.modularui.network.NetworkHandler;
import brachy.modularui.screen.ModularContainerMenu;
import brachy.modularui.test.ModularUITestingRegistration;
import brachy.modularui.theme.ThemeManager;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CommonProxy {
    public CommonProxy() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::registerReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModularUIConfig.CONFIG, "modularui.toml");
        UIFactories.init();
        InventoryTypes.init();
        NetworkHandler.init();
        ModularUIMenuTypes.register(modBus);
        if (ModularUI.isDev()) {
            ModularUITestingRegistration.register(modBus);
        }
    }

    public void onTick(TickEvent.PlayerTickEvent event) {
        AbstractContainerMenu abstractContainerMenu = event.player.f_36096_;
        if (abstractContainerMenu instanceof ModularContainerMenu) {
            ModularContainerMenu containerMenu = (ModularContainerMenu)abstractContainerMenu;
            containerMenu.onUpdate();
        }
    }

    public void registerReloadListeners(AddReloadListenerEvent event) {
        ModularUI.updateFrozenRegistry(event.getRegistryAccess());
        if (ModularUI.isClientThread()) {
            event.addListener((PreparableReloadListener)new ThemeManager());
        }
    }

    public void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"mui").then(Commands.m_82127_((String)"reload_themes").executes(ctx -> {
            ThemeManager.reload();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"ModularUI Themes reloaded").m_130940_(IKey.GREEN), true);
            return 1;
        }));
        event.getDispatcher().register(command);
    }
}

