package brachy.modularui.utils;

import brachy.modularui.utils.serialization.network.IByteBufAdapter;
import brachy.modularui.utils.serialization.network.IByteBufDeserializer;
import brachy.modularui.utils.serialization.network.IByteBufSerializer;

import net.minecraft.network.FriendlyByteBuf;

import io.netty.buffer.Unpooled;

public interface ICopy<T> {

    static <T> ICopy<T> immutable() {
        return t -> t;
    }

    static <T> ICopy<T> ofSerializer(IByteBufSerializer<T> serializer, IByteBufDeserializer<T> deserializer) {
        return t -> {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            serializer.serialize(buf, t);
            return deserializer.deserialize(buf);
        };
    }

    static <T> ICopy<T> ofSerializer(IByteBufAdapter<T> adapter) {
        return ofSerializer(adapter, adapter);
    }

    T createDeepCopy(T t);

    static <T> ICopy<T> wrapNullSafe(ICopy<T> copy) {
        return t -> t == null ? null : copy.createDeepCopy(t);
    }
}
