package brachy.modularui.api;

import brachy.modularui.ModularUI;
import brachy.modularui.factory.GuiData;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.UISettings;
import brachy.modularui.value.sync.PanelSyncManager;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

/**
 * An interface to implement on {@link net.minecraft.world.level.block.entity.BlockEntity} or
 * {@link net.minecraft.world.item.Item}.
 */
@FunctionalInterface
public interface IUIHolder<T extends GuiData> {

    /**
     * Only called on client side.
     *
     * @param data      information about the creation context
     * @param mainPanel the panel created in {@link #buildUI(GuiData, PanelSyncManager, UISettings)}
     * @return a modular screen instance with the given panel
     */
    @OnlyIn(Dist.CLIENT)
    default ModularScreen createScreen(T data, ModularPanel mainPanel) {
        ModularUI.LOGGER
                .warn("IGuiHolder.createScreen() should be overridden to pass your own mod id to the ModularScreen. " +
                        "In future versions this method must be overridden or else it will crash!");
        return new ModularScreen(ModularUI.MOD_ID, mainPanel);
    }

    /**
     * Called on server and client. Create only the main panel here. Only here you can add sync handlers to widgets
     * directly.
     * If the widget to be synced is not in this panel yet (f.e. in another panel) the sync handler must be registered
     * here
     * with {@link PanelSyncManager}.
     *
     * @param data        information about the creation context
     * @param syncManager sync handler where widget sync handlers should be registered
     * @param settings    settings which apply to the whole ui and not just this panel
     */
    ModularPanel buildUI(T data, PanelSyncManager syncManager, UISettings settings);
}
