/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.textfield;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.widget.IFocusedWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.TextFieldTheme;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.AbstractScrollWidget;
import brachy.modularui.widget.scroll.HorizontalScrollData;
import brachy.modularui.widget.scroll.ScrollData;
import brachy.modularui.widgets.VoidWidget;
import brachy.modularui.widgets.textfield.TextFieldHandler;
import brachy.modularui.widgets.textfield.TextFieldRenderer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class BaseTextFieldWidget<W extends BaseTextFieldWidget<W>>
extends AbstractScrollWidget<VoidWidget, W>
implements IFocusedWidget {
    public static final DecimalFormat format = new DecimalFormat("###.###");
    public static final Pattern NATURAL_NUMS = Pattern.compile("[0-9]*([+\\-*/%^][0-9]*)*");
    public static final Pattern WHOLE_NUMS = Pattern.compile("-?[0-9]*([+\\-*/%^][0-9]*)*");
    public static final Pattern DECIMALS = Pattern.compile("[0-9]*(" + BaseTextFieldWidget.getDecimalSeparator() + "[0-9]*)?([+\\-*/%^][0-9]*(" + BaseTextFieldWidget.getDecimalSeparator() + "[0-9]*)?)*");
    public static final Pattern LETTERS = Pattern.compile("[a-zA-Z]*");
    public static final Pattern ANY = Pattern.compile(".*");
    private static final Pattern BASE_PATTERN = Pattern.compile("[^\u00a7]");
    private static final int CURSOR_BLINK_RATE = 10;
    private static final int DOUBLE_CLICK_THRESHOLD = 300;
    protected TextFieldHandler handler = new TextFieldHandler(this);
    protected TextFieldRenderer renderer = new TextFieldRenderer(this.handler);
    protected Alignment textAlignment = Alignment.CenterLeft;
    protected List<String> lastText;
    protected int scrollOffset = 0;
    protected float scale = 1.0f;
    protected boolean focusOnGuiOpen;
    private int cursorTimer;
    protected long lastClickTime = 0L;
    protected Integer textColor;
    protected Integer markedColor;
    protected Component hintText = null;
    protected Integer hintTextColor;

    public BaseTextFieldWidget() {
        super(new HorizontalScrollData(false, 4), null);
        this.handler.setRenderer(this.renderer);
        this.handler.setScrollArea(this.getScrollArea());
        this.padding(4, 0);
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isChildValid(VoidWidget child) {
        return false;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.handler.setGuiContext(this.getContext());
    }

    @Override
    public void afterInit() {
        super.afterInit();
        if (this.focusOnGuiOpen) {
            this.getContext().focus(this);
            this.handler.markAll();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.isFocused() && ++this.cursorTimer == 10) {
            this.renderer.toggleCursor();
            this.cursorTimer = 0;
        }
    }

    @Override
    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (transformed) {
            WidgetThemeEntry<TextFieldTheme> entry = this.getWidgetTheme(this.getPanel().getTheme(), TextFieldTheme.class);
            TextFieldTheme widgetTheme = entry.theme();
            this.renderer.setColor(this.textColor != null ? this.textColor.intValue() : widgetTheme.getTextColor());
            this.renderer.setCursorColor(this.textColor != null ? this.textColor.intValue() : widgetTheme.getTextColor());
            this.renderer.setMarkedColor(this.markedColor != null ? this.markedColor.intValue() : widgetTheme.getMarkedColor());
            this.setupDrawText(context, widgetTheme);
            this.drawText(context, widgetTheme);
        } else {
            context.getStencil().push(1, 1, this.getArea().w() - 2, this.getArea().h() - 2);
        }
    }

    @Override
    public void postDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            context.getStencil().pop();
            WidgetThemeEntry<WidgetTheme> scrollbarTheme = context.getTheme().getScrollbarTheme();
            this.getScrollArea().drawScrollbar(context, scrollbarTheme.getTheme(this.isHovering()), scrollbarTheme.theme().getBackground());
        }
    }

    protected void setupDrawText(ModularGuiContext context, TextFieldTheme widgetTheme) {
        this.renderer.setSimulate(false);
        this.renderer.setPos(this.getArea().getPadding().left(), this.getArea().getPadding().top());
        this.renderer.setScale(this.scale);
        this.renderer.setAlignment(this.textAlignment, this.getArea().paddedWidth(), this.getArea().paddedHeight());
    }

    protected void drawText(ModularGuiContext context, TextFieldTheme widgetTheme) {
        if (this.handler.isTextEmpty() && this.hintText != null) {
            int c = this.renderer.getColor();
            int hintColor = this.hintTextColor != null ? this.hintTextColor.intValue() : widgetTheme.getHintColor();
            this.renderer.setColor(hintColor);
            this.renderer.draw(context.getGraphics(), Collections.singletonList(this.hintText));
            this.renderer.setColor(c);
        } else {
            this.renderer.draw(context.getGraphics(), this.handler.getTextAsComponents());
        }
        this.getScrollArea().getScrollX().setScrollSize(Math.max(0, (int)(this.renderer.getLastWidth() + 0.5f)));
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getTextFieldTheme();
    }

    @Override
    public boolean isFocused() {
        return this.getContext().isFocused(this);
    }

    @Override
    public void onFocus(ModularGuiContext context) {
        this.cursorTimer = 0;
        this.renderer.setCursor(true);
        this.lastText = new ArrayList<String>(this.handler.getText());
    }

    @Override
    public void onRemoveFocus(ModularGuiContext context) {
        this.renderer.setCursor(false);
        this.cursorTimer = 0;
        this.scrollOffset = 0;
        this.handler.setCursor(0, 0, true, true);
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        Interactable.Result result = super.onMousePressed(mouseX, mouseY, button);
        if (result != Interactable.Result.IGNORE) {
            return Interactable.Result.SUCCESS;
        }
        if (!this.isHovering()) {
            return Interactable.Result.IGNORE;
        }
        if (button == 1) {
            this.handler.clear();
        } else {
            int x = this.getContext().getMouseX() + this.getScrollX();
            int y = this.getContext().getMouseY() + this.getScrollY();
            long now = Util.m_137550_();
            if (this.lastClickTime < 0L) {
                if (now + this.lastClickTime < 300L) {
                    this.handler.markAll();
                    this.lastClickTime = now;
                    return Interactable.Result.SUCCESS;
                }
                this.lastClickTime = 0L;
            } else if (this.lastClickTime > 0L) {
                if (now - this.lastClickTime < 300L) {
                    this.handler.markCurrentLine();
                    this.lastClickTime = -Util.m_137550_();
                    return Interactable.Result.SUCCESS;
                }
                this.lastClickTime = 0L;
            }
            this.handler.setCursor(this.renderer.getCursorPos(this.handler.getText(), x, y), true);
            this.lastClickTime = Util.m_137550_();
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.onMouseDrag(mouseX, mouseY, button, dragX, dragY);
        if (this.isFocused() && !this.getScrollArea().isDragging()) {
            int x = this.getContext().getMouseX() + this.getScrollX();
            int y = this.getContext().getMouseY() + this.getScrollY();
            this.handler.setMainCursor(this.renderer.getCursorPos(this.handler.getText(), x, y), true);
        }
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused()) {
            return Interactable.Result.IGNORE;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                if (this.getMaxLines() > 1) {
                    this.handler.newLine();
                } else {
                    this.getContext().removeFocus();
                }
                return Interactable.Result.SUCCESS;
            }
            case 256: {
                if (ModularUIConfig.escRestoresLastText()) {
                    this.handler.clear();
                    this.handler.insert(this.lastText, this.canScrollHorizontally());
                }
                this.getContext().removeFocus();
                return Interactable.Result.SUCCESS;
            }
            case 263: {
                this.handler.moveCursorLeft((modifiers & 2) != 0, (modifiers & 1) != 0);
                return Interactable.Result.SUCCESS;
            }
            case 262: {
                this.handler.moveCursorRight((modifiers & 2) != 0, (modifiers & 1) != 0);
                return Interactable.Result.SUCCESS;
            }
            case 265: {
                this.handler.moveCursorUp((modifiers & 2) != 0, (modifiers & 1) != 0);
                return Interactable.Result.SUCCESS;
            }
            case 264: {
                this.handler.moveCursorDown((modifiers & 2) != 0, (modifiers & 1) != 0);
                return Interactable.Result.SUCCESS;
            }
            case 261: {
                this.handler.delete(true);
                return Interactable.Result.SUCCESS;
            }
            case 259: {
                this.handler.delete();
                return Interactable.Result.SUCCESS;
            }
        }
        if (Screen.m_96632_((int)keyCode)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.handler.getSelectedText());
            return Interactable.Result.SUCCESS;
        }
        if (Screen.m_96630_((int)keyCode)) {
            if (this.handler.hasTextMarked()) {
                this.handler.delete();
            }
            this.handler.insert(Minecraft.m_91087_().f_91068_.m_90876_().replace("\u00a7", ""), this.canScrollHorizontally());
            return Interactable.Result.SUCCESS;
        }
        if (Screen.m_96628_((int)keyCode) && this.handler.hasTextMarked()) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.handler.getSelectedText());
            this.handler.delete();
            return Interactable.Result.SUCCESS;
        }
        if (Screen.m_96634_((int)keyCode)) {
            this.handler.markAll();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.STOP;
    }

    @Override
    @NotNull
    public Interactable.Result onCharTyped(char codePoint, int modifiers) {
        if (!this.isFocused()) {
            return Interactable.Result.IGNORE;
        }
        if (codePoint == '\u0000') {
            return Interactable.Result.STOP;
        }
        if (BASE_PATTERN.matcher(String.valueOf(codePoint)).matches() && this.handler.test(String.valueOf(codePoint))) {
            if (this.handler.hasTextMarked()) {
                this.handler.delete();
            }
            this.handler.insert(String.valueOf(codePoint), this.canScrollHorizontally());
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.STOP;
    }

    public boolean canScrollHorizontally() {
        return this.getScrollArea().getScrollX() != null;
    }

    public int getMaxLines() {
        return this.handler.getMaxLines();
    }

    public ScrollData getScrollData() {
        return this.getScrollArea().getScrollX();
    }

    public W setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setScale(float scale) {
        this.scale = scale;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setTextColor(int color) {
        this.textColor = color;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setMarkedColor(int color) {
        this.markedColor = color;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W setFocusOnGuiOpen(boolean focusOnGuiOpen) {
        this.focusOnGuiOpen = focusOnGuiOpen;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W hintText(Component hint) {
        this.hintText = hint;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public W hintColor(int color) {
        this.hintTextColor = color;
        return (W)((BaseTextFieldWidget)this.getThis());
    }

    public static char getDecimalSeparator() {
        return format.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public static char getGroupSeparator() {
        return format.getDecimalFormatSymbols().getGroupingSeparator();
    }

    @Generated
    public List<String> getLastText() {
        return this.lastText;
    }
}

