/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.slot;

import brachy.modularui.value.sync.ItemSlotSyncHandler;
import brachy.modularui.widgets.slot.IOnSlotChanged;
import brachy.modularui.widgets.slot.SlotGroup;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularSlot
extends SlotItemHandler {
    public static final Comparator<ModularSlot> SHIFT_CLICK_PRIORITY = Comparator.comparingInt(slot -> Objects.requireNonNull(slot.getSlotGroup()).getShiftClickPriority());
    private boolean enabled = true;
    private boolean canTake = true;
    private boolean canPut = true;
    private Predicate<ItemStack> filter = stack -> true;
    private IOnSlotChanged changeListener = IOnSlotChanged.DEFAULT;
    private boolean ignoreMaxStackSize = false;
    @Nullable
    private String slotGroupName = null;
    @Nullable
    private SlotGroup slotGroup = null;
    private boolean phantom = false;
    private ItemSlotSyncHandler syncHandler = null;

    public ModularSlot(IItemHandler itemHandler, int index) {
        super(itemHandler, index, Integer.MIN_VALUE, Integer.MIN_VALUE);
        if (index < 0 || index >= itemHandler.getSlots()) {
            throw new IllegalArgumentException("Tried to create a slot with invalid index " + index + ". Valid index range is [0," + itemHandler.getSlots() + ")");
        }
    }

    @ApiStatus.Internal
    public void initialize(ItemSlotSyncHandler syncManager, boolean phantom) {
        this.syncHandler = syncManager;
        this.phantom = phantom;
    }

    @ApiStatus.Internal
    public void dispose() {
        this.syncHandler = null;
        this.phantom = false;
    }

    public boolean isInitialized() {
        return this.syncHandler != null;
    }

    public boolean m_5857_(@NotNull ItemStack stack) {
        return this.canPut && !stack.m_41619_() && this.filter.test(stack) && super.m_5857_(stack);
    }

    public boolean m_8010_(Player playerIn) {
        return this.canTake && super.m_8010_(playerIn);
    }

    public int m_5866_(@NotNull ItemStack stack) {
        return this.ignoreMaxStackSize ? this.m_6641_() : super.m_5866_(stack);
    }

    public void m_6654_() {
    }

    public void onSlotChangedReal(ItemStack itemStack, boolean onlyChangedAmount, boolean client, boolean init) {
        this.changeListener.onChange(itemStack, onlyChangedAmount, client, init);
        if (!init && this.isInitialized()) {
            this.getSyncHandler().getSyncManager().getContainer().onSlotChanged(this, itemStack, onlyChangedAmount);
        }
    }

    public void onCraftShiftClick(Player playerIn, ItemStack itemStack) {
    }

    public void m_5852_(@NotNull ItemStack stack) {
        if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)this.m_7993_())) {
            return;
        }
        super.m_5852_(stack);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return null;
    }

    public boolean m_6659_() {
        return this.isEnabled();
    }

    @NotNull
    public ItemSlotSyncHandler getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("ModularSlot is not yet initialized");
        }
        return this.syncHandler;
    }

    protected Player getPlayer() {
        return this.getSyncHandler().getSyncManager().getPlayer();
    }

    public ModularSlot filter(Predicate<ItemStack> filter) {
        this.filter = filter != null ? filter : stack -> true;
        return this;
    }

    public ModularSlot changeListener(IOnSlotChanged changeListener) {
        this.changeListener = changeListener != null ? changeListener : IOnSlotChanged.DEFAULT;
        return this;
    }

    public ModularSlot accessibility(boolean canPut, boolean canTake) {
        this.canPut = canPut;
        this.canTake = canTake;
        return this;
    }

    @ApiStatus.Experimental
    public ModularSlot ignoreMaxStackSize(boolean ignoreMaxStackSize) {
        this.ignoreMaxStackSize = ignoreMaxStackSize;
        return this;
    }

    public ModularSlot slotGroup(String slotGroup) {
        this.slotGroupName = slotGroup;
        return this;
    }

    public ModularSlot slotGroup(SlotGroup slotGroup) {
        if (this.slotGroup == slotGroup) {
            return this;
        }
        if (this.slotGroup != null) {
            this.slotGroup.removeSlot(this);
        }
        this.slotGroup = slotGroup;
        if (this.slotGroup != null) {
            this.slotGroup.addSlot((Slot)this);
        }
        return this;
    }

    public ModularSlot singletonSlotGroup(int shiftClickPriority) {
        this.slotGroupName = null;
        return this.slotGroup(SlotGroup.singleton(((Object)((Object)this)).toString(), shiftClickPriority));
    }

    public ModularSlot singletonSlotGroup() {
        return this.singletonSlotGroup(100);
    }

    public static boolean isPlayerSlot(Slot slot) {
        return slot.f_40218_ instanceof Inventory;
    }

    public static boolean isPlayerSlot(SlotItemHandler slot) {
        return slot.getItemHandler() instanceof PlayerInvWrapper || slot.getItemHandler() instanceof PlayerMainInvWrapper;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @ApiStatus.Internal
    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isIgnoreMaxStackSize() {
        return this.ignoreMaxStackSize;
    }

    @Nullable
    @Generated
    public String getSlotGroupName() {
        return this.slotGroupName;
    }

    @Nullable
    @Generated
    public SlotGroup getSlotGroup() {
        return this.slotGroup;
    }

    @Generated
    public boolean isPhantom() {
        return this.phantom;
    }
}

