/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.slot;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.IVanillaSlot;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.core.mixins.client.AbstractContainerScreenAccessor;
import brachy.modularui.core.mixins.client.ScreenAccessor;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.drawable.text.TextRenderer;
import brachy.modularui.integration.recipeviewer.entry.item.ItemStackList;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.screen.ClientScreenHandler;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.SlotTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.value.sync.ItemSlotSyncHandler;
import brachy.modularui.widget.Widget;
import brachy.modularui.widgets.slot.ModularSlot;
import brachy.modularui.widgets.slot.PhantomItemSlot;
import brachy.modularui.widgets.slot.PlayerSlotType;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSlot
extends Widget<ItemSlot>
implements IVanillaSlot,
Interactable,
IngredientProvider<ItemStack> {
    public static final int SIZE = 18;
    private static final TextRenderer textRenderer = new TextRenderer();
    private ItemSlotSyncHandler syncHandler;
    private RichTooltip tooltip;
    protected UnaryOperator<ItemStack> itemHook;

    public static ItemSlot create(boolean phantom) {
        return phantom ? new PhantomItemSlot() : new ItemSlot();
    }

    public ItemSlot() {
        this.itemTooltip().autoUpdate(true);
        this.itemTooltip().tooltipBuilder(tooltip -> {
            if (!this.isSynced()) {
                return;
            }
            ItemStack stack = this.getSlot().m_7993_();
            this.buildTooltip(stack, (RichTooltip)tooltip);
        });
    }

    @Override
    public void onInit() {
        if (this.getScreen().isOverlay()) {
            throw new IllegalStateException("Overlays can't have slots!");
        }
        this.size(18);
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue instanceof ItemSlotSyncHandler;
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.syncHandler = syncOrValue.castOrThrow(ItemSlotSyncHandler.class);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        boolean shouldBeEnabled = this.areAncestorsEnabled();
        if (shouldBeEnabled != this.getSlot().m_6659_()) {
            this.syncHandler.setEnabled(shouldBeEnabled, true);
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        if (this.syncHandler == null) {
            return;
        }
        Lighting.m_84931_();
        this.drawSlot(context, this.getSlot());
        this.drawOverlay(context);
    }

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        super.drawOverlay(context, widgetTheme);
        this.drawOverlay(context);
    }

    protected void drawOverlay(ModularGuiContext context) {
        if (this.isHovering()) {
            GuiDraw.drawRect(context.getGraphics(), 1.0f, 1.0f, 16.0f, 16.0f, this.getSlotHoverColor());
        }
    }

    @Override
    public void drawForeground(ModularGuiContext context) {
        RichTooltip tooltip = this.getTooltip();
        if (tooltip != null && this.isHoveringFor(tooltip.showUpTimer())) {
            tooltip.draw(context, this.getSlot().m_7993_());
        }
    }

    public void buildTooltip(ItemStack stack, RichTooltip tooltip) {
        if (stack.m_41619_()) {
            return;
        }
        tooltip.addFromItem(stack);
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        PlayerSlotType playerSlotType;
        PlayerSlotType playerSlotType2 = playerSlotType = this.syncHandler != null ? this.syncHandler.getPlayerSlotType() : null;
        if (playerSlotType == null) {
            return theme.getWidgetTheme(IThemeApi.ITEM_SLOT);
        }
        return switch (playerSlotType) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerSlotType.HOTBAR -> theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_HOTBAR);
            case PlayerSlotType.MAIN_INVENTORY -> theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_MAIN_INV);
            case PlayerSlotType.OFFHAND -> theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_OFFHAND);
            case PlayerSlotType.ARMOR -> theme.getWidgetTheme(IThemeApi.ITEM_SLOT_PLAYER_ARMOR);
        };
    }

    public int getSlotHoverColor() {
        WidgetThemeEntry<SlotTheme> theme = this.getWidgetTheme(this.getPanel().getTheme(), SlotTheme.class);
        return theme.theme().getSlotHoverColor();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        ClientScreenHandler.clickSlot(this.getScreen(), (Slot)this.getSlot());
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        ClientScreenHandler.releaseSlot();
        return true;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        ClientScreenHandler.dragSlot(mouseX, mouseY, button, dragX, dragY);
    }

    public ModularSlot getSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public Slot getVanillaSlot() {
        return this.syncHandler.getSlot();
    }

    @Override
    public boolean handleAsVanillaSlot() {
        return true;
    }

    @Override
    @NotNull
    public ItemSlotSyncHandler getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("Widget is not initialised!");
        }
        return this.syncHandler;
    }

    public RichTooltip getItemTooltip() {
        return super.getTooltip();
    }

    public RichTooltip itemTooltip() {
        return super.tooltip();
    }

    @Override
    @Nullable
    public RichTooltip getTooltip() {
        if (this.isSynced() && !this.getSlot().m_7993_().m_41619_()) {
            return this.getItemTooltip();
        }
        return this.tooltip;
    }

    @Override
    public ItemSlot tooltip(RichTooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @Override
    @NotNull
    public RichTooltip tooltip() {
        if (this.tooltip == null) {
            this.tooltip = new RichTooltip().parent(this);
        }
        return this.tooltip;
    }

    public ItemSlot slot(ModularSlot slot) {
        return this.syncHandler(new ItemSlotSyncHandler(slot));
    }

    public ItemSlot slot(IItemHandlerModifiable itemHandler, int index) {
        return this.slot(new ModularSlot((IItemHandler)itemHandler, index));
    }

    public ItemSlot syncHandler(ItemSlotSyncHandler syncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(syncHandler));
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawSlot(ModularGuiContext context, ModularSlot slotIn) {
        Screen guiScreen = this.getScreen().getScreenWrapper().wrappedScreen();
        if (!(guiScreen instanceof AbstractContainerScreen)) {
            throw new IllegalStateException("The gui must be an instance of GuiContainer if it contains slots!");
        }
        AbstractContainerScreenAccessor acc = (AbstractContainerScreenAccessor)guiScreen;
        ItemStack slotStack = slotIn.m_7993_();
        boolean isDragPreview = false;
        boolean doDrawItem = slotIn == acc.getClickedSlot() && !acc.getDraggingItem().m_41619_() && !acc.getIsSplittingStack();
        ItemStack carried = guiScreen.getMinecraft().f_91074_.f_36096_.m_142621_();
        int amount = -1;
        String format = null;
        if (!this.getSyncHandler().isPhantom()) {
            if (slotIn == acc.getClickedSlot() && !acc.getDraggingItem().m_41619_() && acc.getIsSplittingStack() && !slotStack.m_41619_()) {
                slotStack = slotStack.m_41777_();
                slotStack.m_41764_(slotStack.m_41613_() / 2);
            } else if (acc.getIsQuickCrafting() && acc.getQuickCraftSlots().contains((Object)slotIn) && !carried.m_41619_()) {
                if (acc.getQuickCraftSlots().size() == 1) {
                    return;
                }
                if (AbstractContainerMenu.m_38899_((Slot)slotIn, (ItemStack)carried, (boolean)true) && this.getScreen().getContainer().m_5622_((Slot)slotIn)) {
                    slotStack = carried.m_41777_();
                    isDragPreview = true;
                    AbstractContainerMenu.m_278794_(acc.getQuickCraftSlots(), (int)acc.getQuickCraftingType(), (ItemStack)slotStack);
                    int k = Math.min(slotStack.m_41741_(), slotIn.m_5866_(slotStack));
                    if (slotStack.m_41613_() > k) {
                        amount = k;
                        format = ChatFormatting.YELLOW.toString();
                        slotStack.m_41764_(k);
                    }
                } else {
                    acc.getQuickCraftSlots().remove((Object)slotIn);
                    acc.invokeRecalculateQuickCraftRemaining();
                }
            }
        }
        float z = context.getCurrentDrawingZ() + 100;
        context.graphicsPose().m_85836_();
        context.graphicsPose().m_252880_(0.0f, 0.0f, z);
        if (!doDrawItem) {
            if (isDragPreview) {
                GuiDraw.drawRect(context.getGraphics(), 1.0f, 1.0f, 16.0f, 16.0f, -2130706433);
            }
            if (!slotStack.m_41619_()) {
                RenderSystem.enableDepthTest();
                context.getGraphics().m_280480_(slotStack, 1, 1);
                if (amount < 0) {
                    amount = slotStack.m_41613_();
                }
                GuiDraw.drawStandardSlotAmountText(context, amount, format, this.getArea(), z);
                int cachedCount = slotStack.m_41613_();
                slotStack.m_41764_(1);
                context.getGraphics().m_280302_(((ScreenAccessor)guiScreen).getFont(), slotStack, 1, 1, null);
                slotStack.m_41764_(cachedCount);
                RenderSystem.disableDepthTest();
            }
        }
        context.graphicsPose().m_85849_();
    }

    public ItemStackList getIngredients() {
        return ItemStackList.of(this.syncHandler.getSlot().m_7993_());
    }

    @Override
    @NotNull
    public Class<ItemStack> ingredientClass() {
        return ItemStack.class;
    }

    @Override
    public UnaryOperator<ItemStack> renderMappingFunction() {
        return this.itemHook;
    }

    @Generated
    public void setItemHook(UnaryOperator<ItemStack> itemHook) {
        this.itemHook = itemHook;
    }
}

