/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.menu;

import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.value.IValue;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.utils.MutableSingletonList;
import brachy.modularui.widgets.ButtonWidget;
import brachy.modularui.widgets.ListWidget;
import brachy.modularui.widgets.menu.AbstractMenuButton;
import brachy.modularui.widgets.menu.Menu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DropdownWidget<T, W extends DropdownWidget<T, W>>
extends AbstractMenuButton<W> {
    private final Class<T> valueType;
    private final MutableSingletonList<IWidget> selected = new MutableSingletonList();
    private final List<T> values = new ArrayList<T>();
    private IValue<T> value;
    private int maxListSize = 100;
    private ToWidget<T> toWidget;

    public DropdownWidget(String panelName, Class<T> valueType) {
        super(panelName);
        this.valueType = valueType;
        this.openOnHover = false;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setValue(this.value.getValue(), false);
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return this.selected;
    }

    protected IWidget valueToWidget(T v, boolean forSelectedDisplay) {
        if (this.toWidget != null) {
            return this.toWidget.apply(v, forSelectedDisplay);
        }
        return IKey.str(String.valueOf(v)).asWidget();
    }

    protected void setValue(T value, boolean updateValue) {
        if (this.selected.hasValue()) {
            this.selected.get().dispose();
        }
        if (updateValue && this.value != null) {
            this.value.setValue(value);
        }
        this.selected.set(this.valueToWidget(value, true));
        if (this.isValid()) {
            this.selected.get().initialise(this, true);
            this.scheduleResize();
        }
    }

    @Override
    protected Menu<?> createMenu() {
        return (Menu)((Menu)((Menu)new Menu().widthRel(1.0f)).coverChildrenHeight()).child(((ListWidget)((ListWidget)new ListWidget().widthRel(1.0f)).maxSize(this.maxListSize)).children(this.values, v -> ((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().widthRel(1.0f)).coverChildrenHeight()).child(this.valueToWidget(v, false))).onMousePressed((x, y, b) -> {
            this.setValue(v, true);
            this.closeMenu(false);
            return true;
        })));
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isValueOfType(this.valueType);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.value = syncOrValue.castValueNullable(this.valueType);
    }

    public void deleteMenu() {
        this.setMenu(null);
    }

    public W value(IValue<T> value) {
        this.setSyncOrValue(value);
        return (W)((DropdownWidget)this.getThis());
    }

    public W option(T option) {
        this.values.add(option);
        return (W)((DropdownWidget)this.getThis());
    }

    public W options(Iterable<T> options) {
        for (T t : options) {
            this.values.add(t);
        }
        return (W)((DropdownWidget)this.getThis());
    }

    public W options(T ... options) {
        this.values.addAll(Arrays.asList(options));
        return (W)((DropdownWidget)this.getThis());
    }

    public W clearOptions() {
        this.values.clear();
        return (W)((DropdownWidget)this.getThis());
    }

    public W optionToWidget(ToWidget<T> toWidget) {
        this.toWidget = toWidget;
        return (W)((DropdownWidget)this.getThis());
    }

    public W maxVerticalMenuSize(int maxListSize) {
        this.maxListSize = maxListSize;
        return (W)((DropdownWidget)this.getThis());
    }

    public W directionUp() {
        this.direction = AbstractMenuButton.Direction.UP;
        return (W)((DropdownWidget)this.getThis());
    }

    public W directionDown() {
        this.direction = AbstractMenuButton.Direction.DOWN;
        return (W)((DropdownWidget)this.getThis());
    }

    public static interface ToWidget<T> {
        public IWidget apply(T var1, boolean var2);
    }
}

