/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.layout;

import brachy.modularui.ModularUI;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.sizer.Box;
import java.util.ArrayList;
import java.util.List;

public class SimpleFlow {
    public final List<IWidget> widgets = new ArrayList<IWidget>();
    public int size;
    public int expanderCount;
    public int crossSize;
    public boolean crossSizeCalculated;

    public void layout(GuiAxis axis, int availableSize, Box padding, Alignment.MainAxis maa, int childPadding) {
        int amount = this.widgets.size();
        if (this.expanderCount > 0) {
            maa = Alignment.MainAxis.START;
        } else if (amount <= 1 && (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND)) {
            maa = Alignment.MainAxis.CENTER;
        }
        int space = childPadding;
        if (maa == Alignment.MainAxis.SPACE_BETWEEN || maa == Alignment.MainAxis.SPACE_AROUND) {
            space = maa == Alignment.MainAxis.SPACE_BETWEEN ? (availableSize - this.size) / (amount - 1) : (availableSize - this.size) / amount;
        }
        if (this.expanderCount > 0 && availableSize > 0) {
            int newSize = (availableSize - this.size) / this.expanderCount;
            for (IWidget widget : this.widgets) {
                if (!widget.resizer().isExpanded()) continue;
                widget.getArea().setSize(axis, newSize);
                widget.resizer().setSizeResized(axis, true);
            }
        }
        int lastP = padding.getStart(axis);
        if (availableSize > 0) {
            if (maa == Alignment.MainAxis.CENTER) {
                lastP += (int)((float)availableSize / 2.0f - (float)this.size / 2.0f);
            } else if (maa == Alignment.MainAxis.END) {
                lastP += availableSize - this.size;
            } else if (maa == Alignment.MainAxis.SPACE_AROUND) {
                lastP += space / 2;
            }
        }
        for (IWidget widget : this.widgets) {
            Box margin = widget.getArea().getMargin();
            widget.getArea().setRelativePoint(axis, lastP + margin.getStart(axis));
            widget.resizer().setPosResized(axis, true);
            widget.resizer().setMarginPaddingApplied(axis, true);
            lastP += widget.getArea().requestedSize(axis) + space;
        }
    }

    public void calculateCrossAxisSize(GuiAxis axis) {
        GuiAxis other = axis.getOther();
        if (!this.crossSizeCalculated) {
            this.crossSizeCalculated = true;
            this.crossSize = 0;
            for (IWidget widget : this.widgets) {
                if (widget.resizer().hasXPos() || widget.resizer().hasYPos()) continue;
                if (!widget.resizer().isSizeCalculated(other)) {
                    this.crossSizeCalculated = false;
                    continue;
                }
                this.crossSize = Math.max(widget.getArea().requestedSize(other), this.crossSize);
            }
        }
    }

    public boolean layoutCrossAxis(IWidget parent, GuiAxis axis, Alignment.CrossAxis caa, int availableSize, int p, Box padding) {
        GuiAxis other = axis.getOther();
        if (availableSize < 0 && caa != Alignment.CrossAxis.START) {
            return false;
        }
        for (IWidget widget : this.widgets) {
            if (widget.resizer().hasPos(axis)) continue;
            Box margin = widget.getArea().getMargin();
            if (widget.resizer().hasPos(other) || !widget.resizer().isSizeCalculated(other)) continue;
            int start = margin.getStart(other) + padding.getStart(other);
            int crossAxisPos = 0;
            if (caa == Alignment.CrossAxis.START) {
                crossAxisPos = start;
            } else {
                int end = margin.getEnd(other) + padding.getEnd(other);
                int s = widget.getArea().getSize(other);
                if (caa == Alignment.CrossAxis.END) {
                    crossAxisPos = availableSize - s - end;
                } else if (caa == Alignment.CrossAxis.CENTER) {
                    crossAxisPos = (int)((float)availableSize / 2.0f - (float)widget.getArea().getSize(other) / 2.0f);
                    if (availableSize < s + start + end) {
                        ModularUI.LOGGER.warn("Widget {} is larger with padding on axis {} than parent {}. Padding can't be applied correctly!", (Object)widget, (Object)other, (Object)parent);
                    } else if (crossAxisPos < start) {
                        crossAxisPos = start;
                    } else if (crossAxisPos > availableSize - end - s) {
                        crossAxisPos = availableSize - end - s;
                    }
                }
            }
            widget.getArea().setRelativePoint(other, crossAxisPos + p);
            widget.getArea().setPoint(other, parent.getArea().getPoint(other) + crossAxisPos + p);
            widget.resizer().setPosResized(other, true);
            widget.resizer().setMarginPaddingApplied(other, true);
        }
        return true;
    }
}

