/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets.layout;

import brachy.modularui.ModularUI;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.layout.ILayoutWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.ReversedList;
import brachy.modularui.widget.ParentWidget;
import brachy.modularui.widget.sizer.Box;
import brachy.modularui.widget.sizer.ExpanderResizer;
import brachy.modularui.widgets.layout.SimpleFlow;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class Flow
extends ParentWidget<Flow>
implements ILayoutWidget {
    private final GuiAxis axis;
    private Alignment.MainAxis mainAxisAlignment = Alignment.MainAxis.START;
    private Alignment.CrossAxis crossAxisAlignment = Alignment.CrossAxis.CENTER;
    private int childPadding = 0;
    private int crossAxisChildPadding = 0;
    private boolean collapseDisabledChild = false;
    private boolean reverseLayout = false;
    private boolean wrap = false;
    private final List<IWidget> ignoredWidgets = new ArrayList<IWidget>();
    private final List<SimpleFlow> layoutWidgets = new ArrayList<SimpleFlow>();

    public static Flow row() {
        return new Flow(GuiAxis.X);
    }

    public static Flow column() {
        return new Flow(GuiAxis.Y);
    }

    public static Flow col() {
        return new Flow(GuiAxis.Y);
    }

    public Flow(GuiAxis axis) {
        this.axis = axis;
        this.resizer(new ExpanderResizer(this, axis));
        this.sizeRel(1.0f, 1.0f);
    }

    @Override
    public int getDefaultWidth() {
        return this.axis.isHorizontal() ? this.getDefaultMainAxisSize() : this.getDefaultCrossAxisSize();
    }

    @Override
    public int getDefaultHeight() {
        return this.axis.isHorizontal() ? this.getDefaultCrossAxisSize() : this.getDefaultMainAxisSize();
    }

    public int getDefaultMainAxisSize() {
        if (!this.hasChildren()) {
            return 18;
        }
        GuiAxis axis = this.axis;
        int total = this.getArea().getPadding().getTotal(axis);
        for (IWidget widget : this.getChildren()) {
            if (this.shouldIgnoreChildSize(widget) || widget.resizer().hasPos(axis)) continue;
            total = widget.resizer().isExpanded() || !widget.resizer().isSizeCalculated(axis) ? (total += axis.isHorizontal() ? widget.getDefaultWidth() : widget.getDefaultHeight()) : (total += widget.getArea().getSize(axis));
            total += widget.getArea().getMargin().getTotal(axis);
        }
        return total;
    }

    public int getDefaultCrossAxisSize() {
        if (!this.hasChildren()) {
            return 18;
        }
        GuiAxis axis = this.axis.getOther();
        int max = 0;
        for (IWidget widget : this.getChildren()) {
            if (this.shouldIgnoreChildSize(widget)) continue;
            int s = widget.getArea().getMargin().getTotal(axis);
            s = !widget.resizer().isSizeCalculated(axis) ? (s += axis.isHorizontal() ? widget.getDefaultWidth() : widget.getDefaultHeight()) : (s += widget.getArea().getSize(axis));
            max = Math.max(max, s);
        }
        return max + this.getArea().getPadding().getTotal(axis);
    }

    private boolean buildWrappedFlows(List<IWidget> children, int size, boolean wrap) {
        this.layoutWidgets.clear();
        this.ignoredWidgets.clear();
        SimpleFlow currentFlow = new SimpleFlow();
        for (IWidget widget : children) {
            if (this.shouldIgnoreChildSize(widget) || widget.resizer().hasPos(this.axis)) {
                this.ignoredWidgets.add(widget);
                continue;
            }
            boolean isEmpty = currentFlow.widgets.isEmpty();
            if (widget.resizer().isExpanded()) {
                ++currentFlow.expanderCount;
                currentFlow.size += widget.getArea().getMargin().getTotal(this.axis);
                if (!isEmpty) {
                    currentFlow.size += this.childPadding;
                }
                currentFlow.widgets.add(widget);
                if (!wrap) continue;
                this.layoutWidgets.add(currentFlow);
                currentFlow = new SimpleFlow();
                continue;
            }
            if (!widget.resizer().isSizeCalculated(this.axis)) {
                return false;
            }
            int s = widget.getArea().requestedSize(this.axis);
            if (!isEmpty) {
                s += this.childPadding;
            }
            if (wrap && !isEmpty && currentFlow.size + s > size) {
                this.layoutWidgets.add(currentFlow);
                currentFlow = new SimpleFlow();
                s -= this.childPadding;
            }
            currentFlow.size += s;
            currentFlow.widgets.add(widget);
        }
        if (!currentFlow.widgets.isEmpty()) {
            this.layoutWidgets.add(currentFlow);
        }
        return true;
    }

    @Override
    public boolean layoutWidgets() {
        List<IWidget> childrenList;
        if (!this.hasChildren()) {
            return true;
        }
        boolean coverChildren = this.resizer().dependsOnChildren(this.axis);
        boolean wrap = this.wrap;
        if (coverChildren && wrap) {
            ModularUI.LOGGER.warn("Flow can't coverChildren along its main axis and wrap at the same time. Offending widget: {}", (Object)this);
            wrap = false;
        }
        boolean hasSize = this.resizer().isSizeCalculated(this.axis);
        Alignment.MainAxis maa = this.mainAxisAlignment;
        if (!hasSize) {
            if (wrap) {
                return false;
            }
            if (maa != Alignment.MainAxis.START) {
                if (this.resizer().dependsOnChildren(this.axis)) {
                    maa = Alignment.MainAxis.START;
                } else {
                    return false;
                }
            }
        }
        Box padding = this.getArea().getPadding();
        int size = hasSize ? this.getArea().paddedSize(this.axis) : 0;
        List<IWidget> list = childrenList = this.reverseLayout ? new ReversedList<IWidget>(this.getChildren()) : this.getChildren();
        if (!this.buildWrappedFlows(childrenList, size, wrap)) {
            return false;
        }
        for (SimpleFlow flow : this.layoutWidgets) {
            flow.layout(this.axis, size, padding, maa, this.childPadding);
        }
        for (IWidget widget : this.ignoredWidgets) {
            if (this.shouldIgnoreChildSize(widget)) {
                widget.resizer().updateResized();
                widget.resizer().setMarginPaddingApplied(true);
                continue;
            }
            if (!widget.resizer().hasPos(this.axis)) continue;
            widget.resizer().updateResized();
        }
        return true;
    }

    @Override
    public boolean postLayoutWidgets() {
        return Flow.layoutCrossAxisListLike(this, this.layoutWidgets, this.axis, this.crossAxisAlignment, this.crossAxisChildPadding);
    }

    public static boolean layoutCrossAxisListLike(IWidget parent, List<SimpleFlow> flows, GuiAxis axis, Alignment.CrossAxis crossAxisAlignment, int crossAxisSpaceBetween) {
        if (flows.isEmpty()) {
            return true;
        }
        GuiAxis other = axis.getOther();
        boolean isWrapped = flows.size() > 1;
        int availableSize = parent.resizer().hasSize(other) ? parent.getArea().getSize(other) : -1;
        Box padding = parent.getArea().getPadding();
        if (!isWrapped) {
            flows.get(0).calculateCrossAxisSize(axis);
            return flows.get(0).layoutCrossAxis(parent, axis, crossAxisAlignment, availableSize, 0, padding);
        }
        if (parent.resizer().dependsOnChildren(other)) {
            crossAxisAlignment = Alignment.CrossAxis.START;
        }
        if (crossAxisAlignment != Alignment.CrossAxis.START && !parent.resizer().hasSize(other)) {
            return false;
        }
        int total = (flows.size() - 1) * crossAxisSpaceBetween;
        for (SimpleFlow flow : flows) {
            flow.calculateCrossAxisSize(axis);
            total += flow.crossSize;
        }
        int p = parent.getArea().getPadding().getStart(other);
        if (crossAxisAlignment == Alignment.CrossAxis.END) {
            p = availableSize - total - parent.getArea().getMargin().getEnd(other);
        } else if (crossAxisAlignment == Alignment.CrossAxis.CENTER) {
            p = (availableSize - total) / 2;
        }
        crossAxisAlignment = Alignment.CrossAxis.CENTER;
        for (SimpleFlow flow : flows) {
            if (!flow.layoutCrossAxis(parent, axis, crossAxisAlignment, flow.crossSize, p, Box.ZERO)) {
                return false;
            }
            p += flow.crossSize + crossAxisSpaceBetween;
        }
        return true;
    }

    @Override
    public boolean canCoverByDefaultSize(GuiAxis axis) {
        return axis.getOther() == this.axis;
    }

    @Override
    public boolean shouldIgnoreChildSize(IWidget child) {
        return this.collapseDisabledChild && !child.isEnabled();
    }

    @Override
    public void onChildChangeEnabled(IWidget child, boolean enabled) {
        if (this.collapseDisabledChild) {
            ILayoutWidget.super.onChildChangeEnabled(child, enabled);
        }
    }

    public Flow children(Iterable<IWidget> widgets) {
        for (IWidget widget : widgets) {
            this.child(widget);
        }
        return (Flow)this.getThis();
    }

    public Flow children(int amount, IntFunction<IWidget> widgetCreator) {
        for (int i = 0; i < amount; ++i) {
            this.child(widgetCreator.apply(i));
        }
        return (Flow)this.getThis();
    }

    public <T> Flow children(Iterable<T> it, Function<T, IWidget> widgetCreator) {
        for (T t : it) {
            this.child(widgetCreator.apply(t));
        }
        return (Flow)this.getThis();
    }

    public Flow mainAxisAlignment(Alignment.MainAxis maa) {
        this.mainAxisAlignment = maa;
        return this;
    }

    public Flow crossAxisAlignment(Alignment.CrossAxis caa) {
        this.crossAxisAlignment = caa;
        return this;
    }

    public Flow collapseDisabledChild() {
        this.collapseDisabledChild = true;
        return this;
    }

    public Flow collapseDisabledChild(boolean collapse) {
        this.collapseDisabledChild = collapse;
        return this;
    }

    public Flow reverseLayout(boolean reverseLayout) {
        this.reverseLayout = reverseLayout;
        return this;
    }

    public Flow reverseLayout() {
        return this.reverseLayout(true);
    }

    @ApiStatus.Experimental
    public Flow wrap(boolean wrap) {
        this.wrap = wrap;
        return this;
    }

    @ApiStatus.Experimental
    public Flow wrap() {
        return this.wrap(true);
    }

    @ApiStatus.Experimental
    public Flow crossAxisChildPadding(int crossAxisChildPadding) {
        this.crossAxisChildPadding = crossAxisChildPadding;
        return this;
    }

    @Override
    protected String getTypeName() {
        return this.axis.isHorizontal() ? "Row" : "Column";
    }

    @Generated
    public GuiAxis axis() {
        return this.axis;
    }

    @NotNull
    @Generated
    public Flow childPadding(int childPadding) {
        this.childPadding = childPadding;
        return this;
    }
}

