/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.ModularUI;
import brachy.modularui.animation.Animator;
import brachy.modularui.api.widget.IValueWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.screen.viewport.LocatedWidget;
import brachy.modularui.utils.ObjectList;
import brachy.modularui.widget.DraggableWidget;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.StandardResizer;
import brachy.modularui.widgets.ListValueWidget;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class SortableListWidget<T>
extends ListValueWidget<T, Item<T>, SortableListWidget<T>> {
    private Consumer<List<T>> onChange;
    private Consumer<Item<T>> onRemove;
    private int timeSinceLastMove = 0;
    private boolean scheduleAnimation = false;
    private final ObjectList<Area> widgetAreaSnapshots = ObjectList.create();
    private final ObjectList<Animator> animators = ObjectList.create();

    public SortableListWidget() {
        super(Item::getWidgetValue);
        this.heightRel(1.0f);
        this.collapseDisabledChild(false);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.assignIndexes();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ++this.timeSinceLastMove;
    }

    @Override
    public void beforeResize(boolean onOpen) {
        super.beforeResize(onOpen);
        if (this.scheduleAnimation) {
            this.widgetAreaSnapshots.clear();
            this.widgetAreaSnapshots.size(this.getTypeChildren().size());
            this.animators.size(this.getTypeChildren().size());
            @UnmodifiableView @NotNull List<I> typeChildren = this.getTypeChildren();
            for (int i = 0; i < typeChildren.size(); ++i) {
                Item item = (Item)typeChildren.get(i);
                this.widgetAreaSnapshots.set(i, item.getArea().copyOrImmutable());
            }
        }
    }

    @Override
    public void postResize() {
        super.postResize();
        if (this.scheduleAnimation && !this.widgetAreaSnapshots.isEmpty()) {
            @UnmodifiableView @NotNull List<I> typeChildren = this.getTypeChildren();
            for (int i = 0; i < typeChildren.size(); ++i) {
                Item item = (Item)typeChildren.get(i);
                Animator current = (Animator)this.animators.get(i);
                if ((current == null || !current.isAnimating()) && !item.getArea().shouldAnimate((Area)this.widgetAreaSnapshots.get(i))) continue;
                if (current != null) {
                    current.stop(true);
                }
                Animator animator = item.getArea().animator((Area)this.widgetAreaSnapshots.get(i)).duration(150);
                this.animators.set(i, animator);
                animator.animate(true);
            }
        }
        this.scheduleAnimation = false;
    }

    @Override
    public int getDefaultWidth() {
        return 80;
    }

    public void moveTo(int from, int to) {
        if (this.timeSinceLastMove < 3) {
            return;
        }
        if (from < 0 || to < 0 || from == to) {
            ModularUI.LOGGER.error("Failed to move element from {} to {}", (Object)from, (Object)to);
            return;
        }
        Item child = (Item)this.getTypeChildren().remove(from);
        this.getChildren().add(to, child);
        this.assignIndexes();
        if (this.isValid()) {
            this.assignIndexes();
            this.scheduleAnimation = true;
            this.scheduleResize();
        }
        if (this.onChange != null) {
            this.onChange.accept(this.getValues());
        }
        this.timeSinceLastMove = 0;
    }

    @Override
    public boolean remove(int index) {
        Item widget = (Item)this.getTypeChildren().remove(index);
        if (widget != null) {
            widget.dispose();
            this.assignIndexes();
            this.scheduleAnimation = true;
            this.onChildRemove(widget);
            if (this.onChange != null) {
                this.onChange.accept(this.getValues());
            }
            if (this.onRemove != null) {
                this.onRemove.accept(widget);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onChildAdd(Item<T> child) {
        if (this.isValid()) {
            this.assignIndexes();
            this.scheduleAnimation = true;
            if (this.onChange != null) {
                this.onChange.accept(this.getValues());
            }
            this.scheduleResize();
        }
    }

    private void assignIndexes() {
        List children = this.getTypeChildren();
        for (int i = 0; i < children.size(); ++i) {
            ((Item)children.get((int)i)).index = i;
        }
    }

    public SortableListWidget<T> onChange(Consumer<List<T>> onChange) {
        this.onChange = onChange;
        return this;
    }

    public SortableListWidget<T> onRemove(Consumer<Item<T>> onRemove) {
        this.onRemove = onRemove;
        return this;
    }

    public static class Item<T>
    extends DraggableWidget<Item<T>>
    implements IValueWidget<T> {
        private final T value;
        private List<IWidget> children;
        private Predicate<IWidget> dropPredicate;
        private SortableListWidget<T> listWidget;
        private int index = -1;
        private final int movingFrom = -1;

        public Item(T value) {
            this.value = value;
            ((StandardResizer)this.resizer().widthRel(1.0f)).height(18);
            this.background(GuiTextures.BUTTON_CLEAN);
        }

        @Override
        public void onInit() {
            super.onInit();
            IWidget iWidget = this.getParent();
            if (iWidget instanceof SortableListWidget) {
                SortableListWidget sortableListWidget;
                this.listWidget = sortableListWidget = (SortableListWidget)iWidget;
            }
        }

        @Override
        @NotNull
        public List<IWidget> getChildren() {
            return this.children != null ? this.children : Collections.emptyList();
        }

        @Override
        public boolean canDropHere(int x, int y, @Nullable IWidget widget) {
            return this.dropPredicate == null || this.dropPredicate.test(widget);
        }

        @Override
        public void onDrag(int mouseButton, double timeSinceLastClick) {
            super.onDrag(mouseButton, timeSinceLastClick);
            for (LocatedWidget hovering : this.getPanel().getAllHoveringList(false)) {
                Item item;
                Object t = hovering.getElement();
                if (!(t instanceof Item) || (item = (Item)t) == this || item.listWidget != this.listWidget) continue;
                this.listWidget.moveTo(this.index, item.index);
                break;
            }
        }

        @Override
        public void onDragEnd(boolean successful) {
        }

        @Override
        public T getWidgetValue() {
            return this.value;
        }

        public boolean removeSelfFromList() {
            this.listWidget.remove(this.index);
            return true;
        }

        public Item<T> child(IWidget widget) {
            this.children = Collections.singletonList(widget);
            if (this.isValid()) {
                widget.initialise(this, true);
            }
            return this;
        }

        public Item<T> child(Function<Item<T>, IWidget> widgetCreator) {
            return this.child(widgetCreator.apply(this));
        }

        public Item<T> dropPredicate(Predicate<IWidget> dropPredicate) {
            this.dropPredicate = dropPredicate;
            return this;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }
    }
}

