/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.widget.IWidget;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.drawable.UITexture;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widgets.ButtonWidget;
import brachy.modularui.widgets.SlotGroupWidget;
import brachy.modularui.widgets.slot.ItemSlot;
import brachy.modularui.widgets.slot.SlotGroup;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class SortButtons
extends Widget<SortButtons> {
    public static final UITexture HOVER_SORT_OVERLAY = GuiTextures.BLOCK;
    public static final UITexture HOVER_SETTINGS_OVERLAY = GuiTextures.BLOCK;
    private String slotGroupName;
    private SlotGroup slotGroup;
    private boolean horizontal = true;
    private final ButtonWidget<?> sortButton = new ButtonWidget();
    private final ButtonWidget<?> settingsButton = new ButtonWidget();
    @NotNull
    private final List<IWidget> children = Arrays.asList(this.sortButton, this.settingsButton);

    public void sort() {
        Slot slot;
        SlotGroup slotGroup = this.findFirstSlotGroup();
        if (slotGroup == null || (slot = slotGroup.getFirstSlotForSorting()) != null) {
            // empty if block
        }
    }

    public SlotGroup findFirstSlotGroup() {
        if (!this.isValid()) {
            return null;
        }
        if (this.slotGroup != null) {
            return this.slotGroup;
        }
        SlotGroupWidget sgw = this.findSlotGroupParent();
        for (IWidget child : sgw.getChildren()) {
            ItemSlot itemSlot;
            SlotGroup sg;
            if (!(child instanceof ItemSlot) || (sg = (itemSlot = (ItemSlot)child).getSlot().getSlotGroup()) == null || !sg.isAllowSorting()) continue;
            return sg;
        }
        return null;
    }

    public SlotGroupWidget findSlotGroupParent() {
        SlotGroupWidget sgw = WidgetTree.findParent(this, SlotGroupWidget.class);
        if (sgw == null) {
            throw new IllegalArgumentException("If the sort buttons don't have a SlotGroupWidget above itself in the widget tree, then it needs a slot group or name specified. Both were not found.");
        }
        return sgw;
    }

    @Override
    public void onInit() {
        super.onInit();
        if (this.slotGroup != null || this.slotGroupName != null) {
            this.slotGroup = this.getScreen().getContainer().validateSlotGroup(this.getPanel().getName(), this.slotGroupName, this.slotGroup);
        }
        if (this.horizontal) {
            this.size(20, 10);
            this.settingsButton.pos(10, 0);
        } else {
            this.size(10, 20);
            this.settingsButton.pos(0, 10);
        }
    }

    @Override
    public void beforeResize(boolean onOpen) {
        super.beforeResize(onOpen);
        if (this.findFirstSlotGroup() == null) {
            this.setEnabled(false);
        }
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    public SortButtons slotGroup(String slotGroupName) {
        this.slotGroupName = slotGroupName;
        return this;
    }

    public SortButtons slotGroup(SlotGroup slotGroup) {
        this.slotGroup = slotGroup;
        return this;
    }

    public SortButtons horizontal() {
        this.horizontal = true;
        return this;
    }

    public SortButtons vertical() {
        this.horizontal = false;
        return this;
    }

    @Generated
    public String getSlotGroupName() {
        return this.slotGroupName;
    }

    @Generated
    public SlotGroup getSlotGroup() {
        return this.slotGroup;
    }

    @Override
    @NotNull
    @Generated
    public List<IWidget> getChildren() {
        return this.children;
    }

    private static /* synthetic */ boolean lambda$new$1(double x, double y, int button) {
        return true;
    }

    private /* synthetic */ boolean lambda$new$0(double x, double y, int button) {
        this.sort();
        return true;
    }
}

