/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.client.schemarenderer.BaseSchemaRenderer;
import brachy.modularui.schema.ISchema;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.MathUtil;
import brachy.modularui.widget.Widget;
import brachy.modularui.widgets.ButtonWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SchemaWidget
extends Widget<SchemaWidget>
implements Interactable {
    private final BaseSchemaRenderer schemaRenderer;
    private boolean enableRotation = true;
    private boolean enableTranslation = true;
    private boolean enableScaling = true;
    private float scale = 10.0f;
    private float pitch = 0.7853982f;
    private float yaw = 0.0f;
    private final Vector3f offset = new Vector3f();

    public SchemaWidget(ISchema schema) {
        this(new BaseSchemaRenderer(schema));
    }

    public SchemaWidget(BaseSchemaRenderer schemaRenderer) {
        this.schemaRenderer = schemaRenderer;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.schemaRenderer.dispose();
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        Vector3fc f = this.schemaRenderer.schema().getFocus();
        this.schemaRenderer.camera().setLookAtAndAngle(f.x() + this.offset.x, f.y() + this.offset.y, f.z() + this.offset.z, this.scale, this.yaw, this.pitch);
        this.schemaRenderer.drawAtZeroPadded(context, this.getArea(), (WidgetTheme)widgetTheme.theme());
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.enableScaling) {
            this.incrementScale((float)(-delta / 12.0));
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        return Interactable.Result.SUCCESS;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        float dx = (float)dragX;
        float dy = (float)dragY;
        if (button == 0 && this.enableRotation) {
            float moveScale = 0.03f;
            this.yaw(this.yaw + dx * moveScale);
            this.pitch(this.pitch + dy * moveScale);
        } else if (button == 2 && this.enableTranslation) {
            float moveScale = 0.09f;
            Vector3f look = this.schemaRenderer.camera().getLookVec().normalize();
            Vector3f right = look.cross(MathUtil.UNIT_Y, new Vector3f()).normalize();
            Vector3f up = right.cross((Vector3fc)look, new Vector3f());
            this.offset.sub((Vector3fc)right.mul(dx * moveScale)).add((Vector3fc)up.mul(dy * moveScale));
        }
    }

    public void incrementScale(float amount) {
        this.scale += amount;
        this.scale = Math.max(this.scale, 0.001f);
    }

    public SchemaWidget scale(float scale) {
        this.scale = scale;
        return this;
    }

    public SchemaWidget pitch(float pitch) {
        this.pitch = Mth.m_14036_((float)pitch, (float)-1.5697963f, (float)1.5697963f);
        return this;
    }

    public SchemaWidget yaw(float yaw) {
        this.yaw = (yaw + (float)Math.PI * 2) % ((float)Math.PI * 2);
        return this;
    }

    public SchemaWidget offset(float x, float y, float z) {
        this.offset.set(x, y, z);
        return this;
    }

    public SchemaWidget enableDragRotation(boolean enable) {
        this.enableRotation = enable;
        return this;
    }

    public SchemaWidget enableDragTranslation(boolean enable) {
        this.enableTranslation = enable;
        return this;
    }

    public SchemaWidget enableScrollScaling(boolean enable) {
        this.enableScaling = enable;
        return this;
    }

    public SchemaWidget enableInteraction(boolean rotation, boolean translation, boolean scaling) {
        return this.enableDragRotation(rotation).enableDragTranslation(translation).enableScrollScaling(scaling);
    }

    public SchemaWidget enableAllInteraction(boolean enable) {
        return this.enableInteraction(enable, enable, enable);
    }

    public static class LayerButton
    extends ButtonWidget<LayerButton> {
        private final int minLayer;
        private final int maxLayer;
        private int currentLayer = Integer.MIN_VALUE;

        public LayerButton(ISchema schema, int minLayer, int maxLayer) {
            this.minLayer = minLayer;
            this.maxLayer = maxLayer;
            this.overlay(IKey.dynamic(() -> this.currentLayer > Integer.MIN_VALUE ? Component.m_237113_((String)Integer.toString(this.currentLayer)) : Component.m_237113_((String)"ALL")).scale(0.5f));
            this.onMousePressed((mouseX, mouseY, button) -> {
                if (button == 0 || button == 1) {
                    this.currentLayer = button == 0 ? (this.currentLayer == Integer.MIN_VALUE ? minLayer : ++this.currentLayer) : (this.currentLayer == Integer.MIN_VALUE ? maxLayer : --this.currentLayer);
                    if (this.currentLayer > maxLayer || this.currentLayer < minLayer) {
                        this.currentLayer = Integer.MIN_VALUE;
                    }
                    return true;
                }
                return false;
            });
            schema.setRenderFilter((blockPos, blockInfo) -> this.currentLayer == Integer.MIN_VALUE || this.currentLayer >= blockPos.m_123342_());
        }

        public LayerButton startLayer(int start) {
            this.currentLayer = start;
            return this;
        }
    }
}

