/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.ModularUIConfig;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.value.IDoubleValue;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.drawable.UITexture;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Color;
import brachy.modularui.value.DoubleValue;
import brachy.modularui.widget.Widget;
import java.util.function.DoubleSupplier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ProgressWidget
extends Widget<ProgressWidget> {
    private final UITexture[] fullTexture = new UITexture[4];
    private UITexture emptyTexture;
    private Direction direction = Direction.RIGHT;
    private int imageSize = -1;
    private IDoubleValue<?> doubleValue;
    private IDrawable label;
    private int labelWidth;
    private int labelHeight;

    @Override
    public void onInit() {
        if (this.doubleValue == null) {
            this.doubleValue = new DoubleValue(0.5);
        }
        if (this.direction == Direction.CIRCULAR_CW && this.fullTexture[0] != null) {
            UITexture base = this.fullTexture[0];
            this.fullTexture[0] = base.getSubArea(0.0f, 0.5f, 0.5f, 1.0f);
            this.fullTexture[1] = base.getSubArea(0.0f, 0.0f, 0.5f, 0.5f);
            this.fullTexture[2] = base.getSubArea(0.5f, 0.0f, 1.0f, 0.5f);
            this.fullTexture[3] = base.getSubArea(0.5f, 0.5f, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(IDoubleValue.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.doubleValue = syncOrValue.castNullable(IDoubleValue.class);
    }

    @Override
    public void onResized() {
        super.onResized();
        if (this.imageSize < 0) {
            this.imageSize = this.getArea().width;
        }
    }

    public float getCurrentProgress() {
        return (float)this.doubleValue.getDoubleValue();
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> entry) {
        WidgetTheme widgetTheme = this.getActiveWidgetTheme(entry, this.isHovering());
        if (this.emptyTexture != null) {
            this.emptyTexture.draw(context, 0, 0, this.getArea().w(), this.getArea().h(), widgetTheme);
            Color.setGlColorOpaque(Color.WHITE.main);
        }
        float progress = this.getCurrentProgress();
        if (this.fullTexture[0] != null && progress > 0.0f) {
            if (this.direction == Direction.CIRCULAR_CW) {
                this.drawCircular(context, progress, widgetTheme);
                return;
            }
            progress = this.getProgressUV(progress);
            float u0 = 0.0f;
            float v0 = 0.0f;
            float u1 = 1.0f;
            float v1 = 1.0f;
            float x = 0.0f;
            float y = 0.0f;
            float width = this.getArea().width;
            float height = this.getArea().height;
            float labelXOffset = 0.0f;
            float labelYOffset = 0.0f;
            switch (this.direction) {
                case RIGHT: {
                    u1 = progress;
                    width *= progress;
                    labelXOffset = (float)(-this.labelWidth) / 2.0f;
                    labelYOffset = -height / 2.0f - 2.0f;
                    break;
                }
                case LEFT: {
                    u0 = 1.0f - progress;
                    x = (float)this.getArea().width - (width *= progress);
                    labelXOffset = (float)(-this.labelWidth) / 2.0f;
                    labelYOffset = -height / 2.0f - 2.0f;
                    break;
                }
                case DOWN: {
                    v1 = progress;
                    height *= progress;
                    labelXOffset = width / 2.0f + 2.0f;
                    labelYOffset = (float)(-this.labelHeight) / 2.0f;
                    break;
                }
                case UP: {
                    v0 = 1.0f - progress;
                    y = (float)this.getArea().height - (height *= progress);
                    labelXOffset = width / 2.0f + 2.0f;
                    labelYOffset = (float)(-this.labelHeight) / 2.0f;
                }
            }
            this.fullTexture[0].drawSubArea(context, x, y, width, height, u0, v0, u1, v1, widgetTheme);
            if (this.label != null) {
                this.label.draw(context, (int)(x + labelXOffset - width), (int)(y + labelYOffset), this.labelWidth, this.labelHeight, widgetTheme);
            }
        }
    }

    public float getProgressUV(float uv) {
        if (ModularUIConfig.smoothProgressBars()) {
            return uv;
        }
        return (float)(Math.floor(uv * (float)this.imageSize) / (double)this.imageSize);
    }

    private void drawCircular(GuiContext context, float progress, WidgetTheme widgetTheme) {
        float[] subAreas = new float[]{this.getProgressUV(Mth.m_14036_((float)(progress / 0.25f), (float)0.0f, (float)1.0f)), this.getProgressUV(Mth.m_14036_((float)((progress - 0.25f) / 0.25f), (float)0.0f, (float)1.0f)), this.getProgressUV(Mth.m_14036_((float)((progress - 0.5f) / 0.25f), (float)0.0f, (float)1.0f)), this.getProgressUV(Mth.m_14036_((float)((progress - 0.75f) / 0.25f), (float)0.0f, (float)1.0f))};
        float halfWidth = (float)this.getArea().width / 2.0f;
        float halfHeight = (float)this.getArea().height / 2.0f;
        float progressScaled = subAreas[0] * halfHeight;
        this.fullTexture[0].drawSubArea(context, 0.0f, (float)this.getArea().height - progressScaled, halfWidth, progressScaled, 0.0f, 1.0f - progressScaled / halfHeight, 1.0f, 1.0f, widgetTheme);
        progressScaled = subAreas[1] * halfWidth;
        this.fullTexture[1].drawSubArea(context, 0.0f, 0.0f, progressScaled, halfHeight, 0.0f, 0.0f, progressScaled / halfWidth, 1.0f, widgetTheme);
        progressScaled = subAreas[2] * halfHeight;
        this.fullTexture[2].drawSubArea(context, halfWidth, 0.0f, halfWidth, progressScaled, 0.0f, 0.0f, 1.0f, progressScaled / halfHeight, widgetTheme);
        progressScaled = subAreas[3] * halfWidth;
        this.fullTexture[3].drawSubArea(context, (float)this.getArea().width - progressScaled, halfHeight, progressScaled, halfHeight, 1.0f - progressScaled / halfWidth, 0.0f, 1.0f, 1.0f, widgetTheme);
    }

    public ProgressWidget value(IDoubleValue<?> value) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(value));
        return this;
    }

    public ProgressWidget progress(DoubleSupplier progress) {
        return this.value(new DoubleValue.Dynamic(progress, null));
    }

    public ProgressWidget progress(double progress) {
        return this.value(new DoubleValue(progress));
    }

    public ProgressWidget texture(UITexture emptyTexture, UITexture fullTexture, int imageSize) {
        this.emptyTexture = emptyTexture;
        this.fullTexture[0] = fullTexture;
        this.imageSize = imageSize;
        return this;
    }

    public ProgressWidget texture(UITexture texture, int imageSize) {
        return this.texture(texture.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), texture.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), imageSize);
    }

    public ProgressWidget direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    public ProgressWidget label(IDrawable label, int width, int height) {
        this.label = label;
        this.labelWidth = width;
        this.labelHeight = height;
        return this;
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN,
        CIRCULAR_CW;

    }
}

