/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.DrawableStack;
import brachy.modularui.drawable.TabTexture;
import brachy.modularui.theme.SelectableTheme;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.widget.Widget;
import brachy.modularui.widgets.PagedWidget;
import org.jetbrains.annotations.NotNull;

public class PageButton
extends Widget<PageButton>
implements Interactable {
    private final int index;
    private final PagedWidget.Controller controller;
    private IDrawable inactiveTexture = null;
    private boolean invert = false;

    public PageButton(int index, PagedWidget.Controller controller) {
        this.index = index;
        this.controller = controller;
        this.disableHoverBackground();
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getToggleButtonTheme();
    }

    @Override
    protected WidgetTheme getActiveWidgetTheme(WidgetThemeEntry<?> widgetTheme, boolean hover) {
        SelectableTheme selectableTheme = widgetTheme.expectType(SelectableTheme.class).getTheme(hover);
        return this.isActive() ^ this.invertSelected() ? selectableTheme : selectableTheme.getSelected();
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            this.controller.setPage(this.index);
            Interactable.playButtonClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public IDrawable getBackground() {
        return this.isActive() || this.inactiveTexture == null ? super.getBackground() : this.inactiveTexture;
    }

    public boolean isActive() {
        return this.controller.getActivePageIndex() == this.index;
    }

    public PageButton background(boolean active, IDrawable ... background) {
        if (active) {
            return (PageButton)this.background(background);
        }
        this.inactiveTexture = background.length == 0 ? null : (background.length == 1 ? background[0] : new DrawableStack(background));
        return this;
    }

    public PageButton tab(TabTexture texture, int location) {
        return (PageButton)((PageButton)this.background(this.invertSelected(), texture.get(location, this.invertSelected())).background(!this.invertSelected(), texture.get(location, !this.invertSelected())).disableHoverBackground()).size(texture.getWidth(), texture.getHeight());
    }

    public PageButton invertSelected(boolean invert) {
        this.invert = invert;
        return (PageButton)this.getThis();
    }

    public boolean invertSelected() {
        return this.invert;
    }
}

