/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.drawable.IIcon;
import brachy.modularui.api.layout.ILayoutWidget;
import brachy.modularui.api.widget.IParentWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.ReversedList;
import brachy.modularui.widget.AbstractScrollWidget;
import brachy.modularui.widget.scroll.ScrollData;
import brachy.modularui.widget.scroll.VerticalScrollData;
import brachy.modularui.widget.sizer.Unit;
import brachy.modularui.widgets.layout.Flow;
import brachy.modularui.widgets.layout.SimpleFlow;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import lombok.Generated;

public class ListWidget<I extends IWidget, W extends ListWidget<I, W>>
extends AbstractScrollWidget<I, W>
implements ILayoutWidget,
IParentWidget<I, W> {
    private ScrollData scrollData;
    private IIcon childSeparator;
    private final IntList separatorPositions = new IntArrayList();
    private boolean collapseDisabledChild = true;
    private boolean wrapTight = false;
    private Alignment.CrossAxis crossAxisAlignment = Alignment.CrossAxis.CENTER;
    private Unit mainAxisMaxSize;
    private boolean reverseLayout = false;

    public ListWidget() {
        super(null, null);
    }

    @Override
    public void onInit() {
        if (this.scrollData == null) {
            this.scrollDirection(new VerticalScrollData());
        }
    }

    @Override
    public void beforeResize(boolean onOpen) {
        super.beforeResize(onOpen);
        if (this.mainAxisMaxSize != null) {
            this.resizer().setUnit(this.mainAxisMaxSize, this.getAxis(), Unit.State.SIZE);
        }
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        int h;
        int w;
        if (this.childSeparator == null || this.separatorPositions.isEmpty()) {
            return;
        }
        GuiAxis axis = this.scrollData.getAxis();
        int x = this.getArea().getPadding().left();
        int y = this.getArea().getPadding().top();
        if (axis.isHorizontal()) {
            w = this.childSeparator.getWidth();
            h = this.getArea().h() - this.getArea().getPadding().vertical();
        } else {
            w = this.getArea().w() - this.getArea().getPadding().horizontal();
            h = this.childSeparator.getHeight();
        }
        IntListIterator intListIterator = this.separatorPositions.iterator();
        while (intListIterator.hasNext()) {
            int p = (Integer)intListIterator.next();
            if (axis.isHorizontal()) {
                x = p;
            } else {
                y = p;
            }
            this.childSeparator.draw(context, x, y, w, h, this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public boolean layoutWidgets() {
        if (!this.hasChildren()) {
            return true;
        }
        if (this.wrapTight && !this.resizer().isSizeCalculated(this.getAxis())) {
            return false;
        }
        this.separatorPositions.clear();
        GuiAxis axis = this.getAxis();
        int separatorSize = this.getSeparatorSize();
        int p = this.getArea().getPadding().getStart(axis);
        for (IWidget widget : this.getOrderedChildren()) {
            if (this.shouldIgnoreChildSize(widget)) {
                widget.resizer().updateResized();
                continue;
            }
            if (widget.resizer().hasPos(axis)) {
                widget.resizer().updateResized();
                continue;
            }
            if (!widget.resizer().isSizeCalculated(axis)) {
                return false;
            }
            widget.getArea().setRelativePoint(axis, p += widget.getArea().getMargin().getStart(axis));
            widget.resizer().setPosResized(axis, true);
            widget.resizer().setMarginPaddingApplied(true);
            this.separatorPositions.add(p += widget.getArea().getSize(axis) + widget.getArea().getMargin().getEnd(axis));
            p += separatorSize;
        }
        int size = p + this.getArea().getPadding().getEnd(axis);
        this.getScrollData().setScrollSize(size);
        int widgetSize = this.getArea().getSize(axis);
        if (this.wrapTight && size < widgetSize) {
            this.getArea().setSize(this.getAxis(), size);
            this.resizer().setSizeResized(axis, true);
            if (this.resizer().isPosCalculated(axis)) {
                this.resizer().setPosResized(axis, false);
            }
        }
        return true;
    }

    @Override
    public boolean postLayoutWidgets() {
        SimpleFlow flow = new SimpleFlow();
        flow.widgets.addAll(this.getChildren());
        return Flow.layoutCrossAxisListLike(this, Collections.singletonList(flow), this.getAxis(), this.crossAxisAlignment, 0);
    }

    @Override
    public boolean canCoverByDefaultSize(GuiAxis axis) {
        return axis.getOther() == this.getAxis();
    }

    @Override
    public boolean shouldIgnoreChildSize(IWidget child) {
        return this.collapseDisabledChild && !child.isEnabled();
    }

    @Override
    public void onChildChangeEnabled(IWidget child, boolean enabled) {
        if (this.collapseDisabledChild) {
            ILayoutWidget.super.onChildChangeEnabled(child, enabled);
        }
    }

    @Override
    public boolean addChild(I child, int index) {
        return super.addChild(child, index);
    }

    @Override
    public boolean remove(I child) {
        return super.remove(child);
    }

    @Override
    public boolean remove(int index) {
        return super.remove(index);
    }

    @Override
    protected void onChildAdd(I child) {
        super.onChildAdd(child);
        if (this.isValid()) {
            this.scheduleResize();
            this.scrollData.clamp(this.getScrollArea());
        }
    }

    @Override
    protected boolean removeAll() {
        return super.removeAll();
    }

    @Override
    protected void onChildRemove(I child) {
        super.onChildRemove(child);
        if (this.isValid()) {
            this.scheduleResize();
            this.scrollData.clamp(this.getScrollArea());
        }
    }

    public int getSeparatorSize() {
        if (this.childSeparator == null) {
            return 0;
        }
        return this.getAxis().isHorizontal() ? this.childSeparator.getWidth() : this.childSeparator.getHeight();
    }

    public GuiAxis getAxis() {
        return this.scrollData.getAxis();
    }

    public List<IWidget> getOrderedChildren() {
        return this.reverseLayout ? new ReversedList<IWidget>(this.getChildren()) : this.getChildren();
    }

    private W maxSize(float v, int offset, Unit.Measure measure) {
        if (this.mainAxisMaxSize == null) {
            this.mainAxisMaxSize = new Unit();
        }
        this.mainAxisMaxSize.setValue(v);
        this.mainAxisMaxSize.setOffset(offset);
        this.mainAxisMaxSize.setMeasure(measure);
        return this.wrapTight();
    }

    private W maxSize(DoubleSupplier v, int offset, Unit.Measure measure) {
        if (this.mainAxisMaxSize == null) {
            this.mainAxisMaxSize = new Unit();
        }
        this.mainAxisMaxSize.setValue(v);
        this.mainAxisMaxSize.setOffset(offset);
        this.mainAxisMaxSize.setMeasure(measure);
        return this.wrapTight();
    }

    public W maxSize(int v) {
        return this.maxSize(v, 0, Unit.Measure.PIXEL);
    }

    public W maxSizeRel(float v) {
        return this.maxSize(v, 0, Unit.Measure.RELATIVE);
    }

    public W maxSizeRelOffset(float v, int offset) {
        return this.maxSize(v, offset, Unit.Measure.RELATIVE);
    }

    public W maxSize(DoubleSupplier v) {
        return this.maxSize(v, 0, Unit.Measure.PIXEL);
    }

    public W maxSizeRel(DoubleSupplier v) {
        return this.maxSize(v, 0, Unit.Measure.RELATIVE);
    }

    public W maxSizeRelOffset(DoubleSupplier v, int offset) {
        return this.maxSize(v, offset, Unit.Measure.RELATIVE);
    }

    public W wrapTight() {
        this.wrapTight = true;
        return (W)((ListWidget)this.getThis());
    }

    public W scrollDirection(GuiAxis axis) {
        return this.scrollDirection(ScrollData.of(axis));
    }

    public W scrollDirection(ScrollData data) {
        this.scrollData = data;
        this.getScrollArea().removeScrollData();
        this.getScrollArea().setScrollData(this.scrollData);
        return (W)((ListWidget)this.getThis());
    }

    public W childSeparator(IIcon separator) {
        this.childSeparator = separator;
        return (W)((ListWidget)this.getThis());
    }

    public W children(Iterable<I> widgets) {
        for (IWidget widget : widgets) {
            this.child(widget);
        }
        return (W)((ListWidget)this.getThis());
    }

    public W children(int amount, IntFunction<I> widgetCreator) {
        for (int i = 0; i < amount; ++i) {
            this.child((IWidget)widgetCreator.apply(i));
        }
        return (W)((ListWidget)this.getThis());
    }

    public <T> W children(Iterable<T> it, Function<T, I> widgetCreator) {
        for (T t : it) {
            this.child((IWidget)widgetCreator.apply(t));
        }
        return (W)((ListWidget)this.getThis());
    }

    public W collapseDisabledChild() {
        this.collapseDisabledChild = true;
        return (W)((ListWidget)this.getThis());
    }

    public W collapseDisabledChild(boolean doCollapse) {
        this.collapseDisabledChild = doCollapse;
        return (W)((ListWidget)this.getThis());
    }

    public W crossAxisAlignment(Alignment.CrossAxis caa) {
        this.crossAxisAlignment = caa;
        return (W)((ListWidget)this.getThis());
    }

    public W reverseLayout(boolean reverseLayout) {
        this.reverseLayout = reverseLayout;
        return (W)((ListWidget)this.getThis());
    }

    @Generated
    public ScrollData getScrollData() {
        return this.scrollData;
    }
}

