/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.value.IValue;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.value.ObjectValue;
import brachy.modularui.widgets.AbstractFluidDisplayWidget;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDisplayWidget
extends AbstractFluidDisplayWidget<FluidDisplayWidget> {
    private IValue<FluidStack> value;
    private int capacity = 0;
    private boolean displayAmount = true;

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isValueOfType(FluidStack.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.value = syncOrValue.castValueNullable(FluidStack.class);
    }

    @Override
    protected boolean displayAmountText() {
        return this.displayAmount;
    }

    @Override
    @Nullable
    protected FluidStack getFluidStack() {
        return this.value != null ? this.value.getValue() : null;
    }

    public FluidDisplayWidget value(IValue<FluidStack> value) {
        this.setSyncOrValue(value);
        return this;
    }

    public FluidDisplayWidget value(FluidStack value) {
        return this.value(new ObjectValue<FluidStack>(FluidStack.class, value));
    }

    public FluidDisplayWidget capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public FluidDisplayWidget displayAmount(boolean displayAmount) {
        this.displayAmount = displayAmount;
        return this;
    }

    public FluidDisplayWidget fluidTooltip(BiConsumer<RichTooltip, FluidStack> tooltip) {
        return (FluidDisplayWidget)((FluidDisplayWidget)this.tooltipAutoUpdate(true)).tooltipBuilder(t -> tooltip.accept((RichTooltip)t, this.getFluidStack()));
    }

    @Override
    @Generated
    public int getCapacity() {
        return this.capacity;
    }
}

