/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.animation.Animator;
import brachy.modularui.animation.MutableObjectAnimator;
import brachy.modularui.api.drawable.IInterpolation;
import brachy.modularui.api.layout.IViewport;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.Interpolation;
import brachy.modularui.utils.Rectangle;
import brachy.modularui.widget.EmptyWidget;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.sizer.Area;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public class Expandable
extends Widget<Expandable>
implements Interactable,
IViewport {
    private IWidget normalView = new EmptyWidget();
    private IWidget expandedView = new EmptyWidget();
    private final List<IWidget> children = Arrays.asList(this.normalView, this.expandedView);
    private List<IWidget> currentChildren = this.children;
    private boolean expanded = false;
    private Area areaSnapshot;
    private Animator animator;
    private BiConsumer<Rectangle, Boolean> stencilTransform;
    private int animationDuration = 300;
    private IInterpolation interpolation = Interpolation.SINE_OUT;

    public Expandable() {
        this.coverChildren();
    }

    @Override
    public void onInit() {
        this.children.set(0, this.normalView);
        this.children.set(1, this.expandedView);
        this.normalView.setEnabled(!this.expanded);
        this.expandedView.setEnabled(this.expanded);
    }

    @Override
    public void beforeResize(boolean onOpen) {
        super.beforeResize(onOpen);
        if (this.resizer().getChildren().isEmpty() || this.resizer().getChildren().size() > 2) {
            throw new IllegalStateException("Invalid Expandable children size");
        }
        if (this.resizer().getChildren().size() > 1) {
            this.resizer().getChildren().remove(1);
        }
        this.resizer().getChildren().set(0, this.expanded ? this.expandedView.resizer() : this.normalView.resizer());
        this.currentChildren = Collections.singletonList(this.expanded ? this.expandedView : this.normalView);
    }

    @Override
    public void postResize() {
        super.postResize();
        this.currentChildren = this.children;
        if (this.animator != null) {
            this.animator.stop(true);
            this.animator = null;
        }
        if (this.areaSnapshot != null) {
            if (this.animationDuration <= 0) {
                if (!this.expanded) {
                    this.normalView.setEnabled(true);
                    this.expandedView.setEnabled(false);
                }
            } else {
                this.animator = new MutableObjectAnimator<Area>(this.getArea(), this.areaSnapshot, this.getArea().copyOrImmutable()).duration(this.animationDuration).curve(this.interpolation).onFinish(() -> {
                    if (!this.expanded) {
                        this.normalView.setEnabled(true);
                        this.expandedView.setEnabled(false);
                    }
                });
                this.animator.animate();
            }
            this.areaSnapshot = null;
        }
    }

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return this.currentChildren;
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        this.toggle();
        return Interactable.Result.SUCCESS;
    }

    public void toggle() {
        this.expanded(!this.expanded);
    }

    @Override
    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            Rectangle rect = new Rectangle(this.getArea());
            rect.x = 0;
            rect.y = 0;
            if (this.stencilTransform != null) {
                this.stencilTransform.accept(rect, this.expanded);
            }
            context.getStencil().push(rect);
        }
    }

    @Override
    public void postDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            context.getStencil().pop();
        }
    }

    public Expandable expanded(boolean expanded) {
        if (this.expanded == expanded) {
            return this;
        }
        this.expanded = expanded;
        if (expanded) {
            this.normalView.setEnabled(false);
            this.expandedView.setEnabled(true);
        }
        if (this.isValid()) {
            if (expanded) {
                this.normalView.setEnabled(false);
                this.expandedView.setEnabled(true);
            }
            this.areaSnapshot = this.getArea().copyOrImmutable();
            this.scheduleResize();
        }
        return this;
    }

    public Expandable collapsedView(IWidget normalView) {
        this.normalView = normalView;
        this.children.set(0, normalView);
        if (this.isValid()) {
            this.normalView.initialise(this, true);
        }
        return this;
    }

    public Expandable expandedView(IWidget expandedView) {
        this.expandedView = expandedView;
        this.children.set(1, expandedView);
        if (this.isValid()) {
            this.expandedView.initialise(this, true);
        }
        return this;
    }

    public Expandable stencilTransform(BiConsumer<Rectangle, Boolean> stencilTransform) {
        this.stencilTransform = stencilTransform;
        return this;
    }

    public Expandable animationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
        return this;
    }

    public Expandable interpolation(IInterpolation interpolation) {
        this.interpolation = interpolation;
        return this;
    }
}

