/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.layout.ILayoutWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Alignment;
import brachy.modularui.widget.AbstractParentWidget;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widgets.ListWidget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CategoryList
extends AbstractParentWidget<IWidget, CategoryList>
implements Interactable,
ILayoutWidget {
    private final List<CategoryList> subCategories = new ArrayList<CategoryList>();
    private boolean expanded = false;
    private int totalHeight = 0;
    private IDrawable expandedOverlay;
    private IDrawable collapsedOverlay;

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        super.drawOverlay(context, widgetTheme);
        if (this.expanded) {
            this.expandedOverlay.drawAtZeroPadded(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        } else {
            this.collapsedOverlay.drawAtZeroPadded(context, this.getArea(), this.getActiveWidgetTheme(widgetTheme, this.isHovering()));
        }
    }

    @Override
    public void onInit() {
        Root root;
        CategoryList categoryList;
        IWidget iWidget;
        super.onInit();
        if (this.expandedOverlay == null) {
            iWidget = this.getParent();
            if (iWidget instanceof CategoryList) {
                categoryList = (CategoryList)iWidget;
                this.expandedOverlay = categoryList.expandedOverlay;
            } else {
                iWidget = this.getParent();
                if (iWidget instanceof Root) {
                    root = (Root)iWidget;
                    this.expandedOverlay = root.expandedOverlay;
                } else {
                    this.expandedOverlay = IDrawable.EMPTY;
                }
            }
        }
        if (this.collapsedOverlay == null) {
            iWidget = this.getParent();
            if (iWidget instanceof CategoryList) {
                categoryList = (CategoryList)iWidget;
                this.collapsedOverlay = categoryList.collapsedOverlay;
            } else {
                iWidget = this.getParent();
                if (iWidget instanceof Root) {
                    root = (Root)iWidget;
                    this.collapsedOverlay = root.collapsedOverlay;
                } else {
                    this.collapsedOverlay = IDrawable.EMPTY;
                }
            }
        }
    }

    @Override
    public void onChildAdd(IWidget child) {
        if (child instanceof CategoryList) {
            CategoryList categoryList = (CategoryList)child;
            this.subCategories.add(categoryList);
        }
        child.setEnabled(this.expanded);
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.expanded(!this.expanded);
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    public void expanded(boolean expanded) {
        if (expanded == this.expanded) {
            return;
        }
        this.expanded = expanded;
        for (IWidget widget : this.getChildren()) {
            widget.setEnabled(expanded);
        }
        this.calculateHeightAndLayout(true);
    }

    /*
     * Unable to fully structure code
     */
    public boolean calculateHeightAndLayout(boolean calculateParents) {
        block9: {
            block8: {
                if (!this.expanded) break block8;
                y = this.getArea().height;
                for (IWidget widget : this.getChildren()) {
                    widget.getArea().ry = y;
                    widget.resizer().setYResized(true);
                    if (!widget.resizer().isHeightCalculated()) {
                        return false;
                    }
                    if (!(widget instanceof CategoryList)) ** GOTO lbl-1000
                    categoryList = (CategoryList)widget;
                    if (categoryList.expanded) {
                        v0 = categoryList.totalHeight;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = widget.getArea().height;
                    }
                    y += v0;
                }
                this.totalHeight = y;
                break block9;
            }
            this.totalHeight = this.getArea().height;
        }
        if (calculateParents) {
            var4_5 = this.getParent();
            if (var4_5 instanceof CategoryList) {
                categoryList = (CategoryList)var4_5;
                categoryList.calculateHeightAndLayout(true);
            } else {
                var4_5 = this.getParent();
                if (var4_5 instanceof Root) {
                    root = (Root)var4_5;
                    root.updateHeight();
                }
            }
        }
        return true;
    }

    @Override
    public boolean layoutWidgets() {
        return this.calculateHeightAndLayout(false);
    }

    public CategoryList setCollapsedOverlay(IDrawable collapsedOverlay) {
        this.collapsedOverlay = collapsedOverlay;
        return this;
    }

    public CategoryList setExpandedOverlay(IDrawable expandedOverlay) {
        this.expandedOverlay = expandedOverlay;
        return this;
    }

    public static class Root
    extends ListWidget<IWidget, Root> {
        private final List<CategoryList> categories = new ArrayList<CategoryList>();
        private IDrawable expandedOverlay = GuiTextures.MOVE_DOWN.asIcon().size(16, 8).alignment(Alignment.CenterRight).marginRight(4);
        private IDrawable collapsedOverlay = GuiTextures.MOVE_RIGHT.asIcon().size(8, 16).alignment(Alignment.CenterRight).marginRight(8);

        @Override
        public void onChildAdd(IWidget child) {
            if (child instanceof CategoryList) {
                CategoryList categoryList = (CategoryList)child;
                this.categories.add(categoryList);
            }
        }

        private void updateHeight() {
            this.layoutWidgets();
            WidgetTree.preApplyPos(this.resizer());
            WidgetTree.applyPos(this.resizer());
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean layoutWidgets() {
            y = 0;
            for (IWidget widget : this.getChildren()) {
                widget.getArea().ry = y;
                widget.resizer().setYResized(true);
                if (!widget.resizer().isHeightCalculated()) {
                    return false;
                }
                if (!(widget instanceof CategoryList)) ** GOTO lbl-1000
                categoryList = (CategoryList)widget;
                if (categoryList.expanded) {
                    v0 = categoryList.totalHeight;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = widget.getArea().height;
                }
                y += v0;
            }
            this.getScrollArea().getScrollY().setScrollSize(y);
            return true;
        }

        public Root setCollapsedOverlay(IDrawable collapsedOverlay) {
            this.collapsedOverlay = collapsedOverlay;
            return this;
        }

        public Root setExpandedOverlay(IDrawable expandedOverlay) {
            this.expandedOverlay = expandedOverlay;
            return this;
        }
    }
}

