/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.ITheme;
import brachy.modularui.api.IThemeApi;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.IGuiAction;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.GuiTextures;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.value.sync.InteractionSyncHandler;
import brachy.modularui.widget.SingleChildWidget;
import org.jetbrains.annotations.NotNull;

public class ButtonWidget<W extends ButtonWidget<W>>
extends SingleChildWidget<W>
implements Interactable {
    private boolean playClickSound = true;
    private Runnable clickSound;
    private IGuiAction.MousePressed mousePressed;
    private IGuiAction.MouseReleased mouseReleased;
    private IGuiAction.MousePressed mouseTapped;
    private IGuiAction.MouseScroll mouseScroll;
    private IGuiAction.KeyPressed keyPressed;
    private IGuiAction.KeyReleased keyReleased;
    private IGuiAction.KeyPressed keyTapped;
    private InteractionSyncHandler syncHandler;

    public static ButtonWidget<?> panelCloseButton() {
        ButtonWidget buttonWidget = new ButtonWidget();
        return ((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)buttonWidget.widgetTheme(IThemeApi.CLOSE_BUTTON)).top(4)).right(4)).overlay(GuiTextures.CROSS_TINY)).onMousePressed((mouseX, mouseY, button) -> {
            if (button == 0 || button == 1) {
                buttonWidget.getPanel().closeIfOpen();
                return true;
            }
            return false;
        });
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getButtonTheme();
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(InteractionSyncHandler.class);
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.syncHandler = syncOrValue.castNullable(InteractionSyncHandler.class);
    }

    public void playClickSound() {
        if (this.playClickSound) {
            if (this.clickSound != null) {
                this.clickSound.run();
            } else {
                Interactable.playButtonClickSound();
            }
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        if (this.mousePressed != null && this.mousePressed.press(mouseX, mouseY, button)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onMousePressed(button)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return this.mouseReleased != null && this.mouseReleased.release(mouseX, mouseY, button) || this.syncHandler != null && this.syncHandler.onMouseReleased(button);
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(double mouseX, double mouseY, int button) {
        if (this.mouseTapped != null && this.mouseTapped.press(mouseX, mouseY, button)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onMouseTapped(button)) {
            this.playClickSound();
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.keyPressed != null && this.keyPressed.press(keyCode, scanCode, modifiers)) {
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onKeyPressed(keyCode, scanCode, modifiers)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.ACCEPT;
    }

    @Override
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased != null && this.keyReleased.release(keyCode, scanCode, modifiers) || this.syncHandler != null && this.syncHandler.onKeyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    @NotNull
    public Interactable.Result onKeyTapped(int keyCode, int scanCode, int modifiers) {
        if (this.keyTapped != null && this.keyTapped.press(keyCode, scanCode, modifiers)) {
            return Interactable.Result.SUCCESS;
        }
        if (this.syncHandler != null && this.syncHandler.onKeyTapped(keyCode, scanCode, modifiers)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        return this.mouseScroll != null && this.mouseScroll.scroll(mouseX, mouseY, delta) || this.syncHandler != null && this.syncHandler.onMouseScroll((int)delta);
    }

    public W onMousePressed(IGuiAction.MousePressed mousePressed) {
        this.mousePressed = mousePressed;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onMouseReleased(IGuiAction.MouseReleased mouseReleased) {
        this.mouseReleased = mouseReleased;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onMouseTapped(IGuiAction.MousePressed mouseTapped) {
        this.mouseTapped = mouseTapped;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onMouseScrolled(IGuiAction.MouseScroll mouseScroll) {
        this.mouseScroll = mouseScroll;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onKeyPressed(IGuiAction.KeyPressed keyPressed) {
        this.keyPressed = keyPressed;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onKeyReleased(IGuiAction.KeyReleased keyReleased) {
        this.keyReleased = keyReleased;
        return (W)((ButtonWidget)this.getThis());
    }

    public W onKeyTapped(IGuiAction.KeyPressed keyTapped) {
        this.keyTapped = keyTapped;
        return (W)((ButtonWidget)this.getThis());
    }

    public W syncHandler(InteractionSyncHandler interactionSyncHandler) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(interactionSyncHandler));
        return (W)((ButtonWidget)this.getThis());
    }

    public W playClickSound(boolean play) {
        this.playClickSound = play;
        return (W)((ButtonWidget)this.getThis());
    }

    public W clickSound(Runnable clickSound) {
        this.clickSound = clickSound;
        return (W)((ButtonWidget)this.getThis());
    }
}

