/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.api.ITheme;
import brachy.modularui.drawable.GuiDraw;
import brachy.modularui.integration.recipeviewer.entry.EntryList;
import brachy.modularui.integration.recipeviewer.entry.fluid.FluidStackList;
import brachy.modularui.integration.recipeviewer.handlers.IngredientProvider;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Alignment;
import brachy.modularui.utils.FormattingUtil;
import brachy.modularui.utils.MathUtil;
import brachy.modularui.utils.math.SIPrefix;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.sizer.Box;
import lombok.Generated;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFluidDisplayWidget<W extends AbstractFluidDisplayWidget<W>>
extends Widget<W>
implements IngredientProvider<FluidStack> {
    public static final String UNIT_BUCKET = "B";
    public static final String UNIT_LITER = "L";
    private final Box contentPadding = new Box().all(1);
    private String unit = "B";
    private SIPrefix baseUnitPrefix = SIPrefix.Milli;
    private boolean flipLighterThanAir = true;

    protected AbstractFluidDisplayWidget() {
        this.size(18);
    }

    @Override
    protected WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getFluidSlotTheme();
    }

    @Override
    public void draw(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        FluidStack fluid = this.getFluidStack();
        if (fluid == null) {
            return;
        }
        int x = this.contentPadding.left();
        int y = this.contentPadding.top();
        int w = this.getArea().width - this.contentPadding.horizontal();
        int h = this.getArea().height - this.contentPadding.vertical();
        float c = this.getCapacity();
        if (c > 0.0f && fluid.getAmount() > 0) {
            int newH = (int)MathUtil.rescaleLinear(fluid.getAmount(), 0.0f, c, 1.0f, h);
            if (!this.flipLighterThanAir || !fluid.getFluid().getFluidType().isLighterThanAir()) {
                y += h - newH;
            }
            h = newH;
        }
        GuiDraw.drawFluidTexture(context.getGraphics(), fluid, x, y, w, h, context.getCurrentDrawingZ());
    }

    @Override
    public void drawOverlay(ModularGuiContext context, WidgetThemeEntry<?> widgetTheme) {
        super.drawOverlay(context, widgetTheme);
        FluidStack fluid = this.getFluidStack();
        if (fluid != null && this.displayAmountText()) {
            String s = FormattingUtil.formatNumberReadable2F(this.getBaseUnitAmount(fluid.getAmount()), false) + this.getBaseUnit();
            GuiDraw.drawScaledAlignedTextInBox(context, s, this.contentPadding.left(), 0, this.getArea().width - this.contentPadding.left(), this.getArea().height, Alignment.BottomRight);
        }
    }

    protected abstract boolean displayAmountText();

    @Nullable
    protected abstract FluidStack getFluidStack();

    protected int getCapacity() {
        return 0;
    }

    public double getBaseUnitAmount(double amount) {
        return amount * this.getBaseUnitSiPrefix().factor;
    }

    public final String getUnit() {
        return this.getBaseUnitSiPrefix().stringSymbol + this.getBaseUnit();
    }

    public String getBaseUnit() {
        return this.unit;
    }

    public SIPrefix getBaseUnitSiPrefix() {
        return this.baseUnitPrefix;
    }

    public W contentPadding(int left, int right, int top, int bottom) {
        this.contentPadding.all(left, right, top, bottom);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W contentPadding(int horizontal, int vertical) {
        this.contentPadding.all(horizontal, vertical);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W contentPadding(int all) {
        this.contentPadding.all(all);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W contentPaddingLeft(int val) {
        this.contentPadding.left(val);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W contentPaddingRight(int val) {
        this.contentPadding.right(val);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W contentPaddingTop(int val) {
        this.contentPadding.top(val);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W contentPaddingBottom(int val) {
        this.contentPadding.bottom(val);
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W fluidUnit(String baseUnitSymbol, SIPrefix baseUnitPrefix) {
        this.unit = baseUnitSymbol;
        this.baseUnitPrefix = baseUnitPrefix;
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    public W flipLighterThanAir(boolean flipLighterThanAir) {
        this.flipLighterThanAir = flipLighterThanAir;
        return (W)((AbstractFluidDisplayWidget)this.getThis());
    }

    @Override
    @NotNull
    public Class<FluidStack> ingredientClass() {
        return FluidStack.class;
    }

    @Override
    public EntryList<FluidStack> getIngredients() {
        return FluidStackList.of(this.getFluidStack());
    }

    @Generated
    public boolean isFlipLighterThanAir() {
        return this.flipLighterThanAir;
    }
}

