/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widgets;

import brachy.modularui.ModularUI;
import brachy.modularui.api.ITheme;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.drawable.IKey;
import brachy.modularui.api.drawable.ITextLine;
import brachy.modularui.api.value.IBoolValue;
import brachy.modularui.api.value.IEnumValue;
import brachy.modularui.api.value.IIntValue;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.drawable.UITexture;
import brachy.modularui.screen.RichTooltip;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.Alignment;
import brachy.modularui.value.IntValue;
import brachy.modularui.widget.SingleChildWidget;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractCycleButtonWidget<W extends AbstractCycleButtonWidget<W>>
extends SingleChildWidget<W>
implements Interactable {
    private static final RichTooltip[] EMPTY_TOOLTIP = new RichTooltip[0];
    private int stateCount = 1;
    private boolean explicitStateCount = false;
    private boolean hasCount = false;
    private IIntValue<?> intValue;
    private int lastValue = -1;
    protected IDrawable[] background = null;
    protected IDrawable[] hoverBackground = null;
    protected IDrawable[] overlay = null;
    protected IDrawable[] hoverOverlay = null;
    protected RichTooltip[] tooltip = EMPTY_TOOLTIP;
    protected IWidget[] stateChildren = null;
    protected IWidget fallbackChild = null;

    @Override
    public void onInit() {
        if (this.intValue == null) {
            this.intValue = new IntValue(0);
        }
        this.updateChild(this.getState());
    }

    @Override
    public boolean isValidSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        return syncOrValue.isTypeOrEmpty(IIntValue.class);
    }

    protected void updateStateCount(int count, boolean explicit) {
        if (count < 1) {
            return;
        }
        if (explicit) {
            this.setStateCount(count);
            this.explicitStateCount = true;
        } else if (!this.explicitStateCount && count > this.stateCount) {
            this.setStateCount(count);
        }
    }

    private void setStateCount(int stateCount) {
        this.hasCount = true;
        if (this.stateCount == stateCount) {
            return;
        }
        this.stateCount = stateCount;
        int currentSize = this.tooltip.length;
        if (stateCount > currentSize) {
            this.tooltip = Arrays.copyOf(this.tooltip, stateCount);
            while (currentSize < stateCount) {
                this.tooltip[currentSize] = new RichTooltip().parent(this);
                ++currentSize;
            }
        } else if (stateCount < currentSize) {
            for (int i = stateCount; i < currentSize; ++i) {
                this.tooltip[i].reset();
            }
        }
        this.background = AbstractCycleButtonWidget.checkArray(this.background, stateCount);
        this.overlay = AbstractCycleButtonWidget.checkArray(this.overlay, stateCount);
        this.hoverBackground = AbstractCycleButtonWidget.checkArray(this.hoverBackground, stateCount);
        this.hoverOverlay = AbstractCycleButtonWidget.checkArray(this.hoverOverlay, stateCount);
        if (this.stateChildren == null) {
            this.stateChildren = new IWidget[stateCount];
        } else if (this.stateChildren.length < stateCount) {
            this.stateChildren = Arrays.copyOf(this.stateChildren, stateCount);
        }
    }

    protected void expectCount() {
        if (!this.hasCount) {
            ModularUI.LOGGER.error("State count for widget {} is required, but has not been set yet!", (Object)this);
        }
    }

    @Override
    protected void setSyncOrValue(@NotNull ISyncOrValue syncOrValue) {
        super.setSyncOrValue(syncOrValue);
        this.intValue = syncOrValue.castNullable(IIntValue.class);
        if (syncOrValue instanceof IEnumValue) {
            IEnumValue enumValue = (IEnumValue)syncOrValue;
            this.updateStateCount(((Enum[])enumValue.getEnumClass().getEnumConstants()).length, true);
        } else if (syncOrValue instanceof IBoolValue) {
            this.updateStateCount(2, true);
        }
    }

    protected int getState() {
        int val = this.intValue.getIntValue();
        if (val != this.lastValue) {
            this.setState(val, false);
        }
        return val;
    }

    public void next() {
        int state = (this.getState() + 1) % this.stateCount;
        this.setState(state, true);
    }

    public void prev() {
        int state = this.getState();
        if (--state == -1) {
            state = this.stateCount - 1;
        }
        this.setState(state, true);
    }

    public void setState(int state, boolean setSource) {
        if (state < 0 || state >= this.stateCount) {
            throw new IndexOutOfBoundsException("CycleButton state out of bounds");
        }
        this.updateChild(state);
        if (setSource) {
            this.intValue.setIntValue(state);
        }
        this.lastValue = state;
        this.markTooltipDirty();
    }

    private void updateChild(int state) {
        IWidget child;
        IWidget iWidget = child = this.stateChildren != null && this.stateChildren.length > state ? this.stateChildren[state] : null;
        if (child != null) {
            this.child(child);
        } else if (this.getChild() != this.fallbackChild) {
            this.child(this.fallbackChild);
        }
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                this.next();
                Interactable.playButtonClickSound();
                return Interactable.Result.SUCCESS;
            }
            case 1: {
                this.prev();
                Interactable.playButtonClickSound();
                return Interactable.Result.SUCCESS;
            }
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public WidgetThemeEntry<?> getWidgetThemeInternal(ITheme theme) {
        return theme.getButtonTheme();
    }

    @Override
    public IDrawable getCurrentBackground(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        int state = this.getState();
        if (this.isHovering() && this.hoverBackground != null && this.hoverBackground[state] != null && this.hoverBackground[state] != IDrawable.NONE) {
            return this.hoverBackground[state];
        }
        return this.background != null && this.background[state] != null ? this.background[state] : super.getCurrentBackground(theme, widgetTheme);
    }

    @Override
    public IDrawable getCurrentOverlay(ITheme theme, WidgetThemeEntry<?> widgetTheme) {
        int state = this.getState();
        if (this.isHovering() && this.hoverOverlay != null && this.hoverOverlay[state] != null && this.hoverOverlay[state] != IDrawable.NONE) {
            return this.hoverOverlay[state];
        }
        return this.overlay != null && this.overlay[state] != null ? this.overlay[state] : super.getCurrentOverlay(theme, widgetTheme);
    }

    @Override
    public boolean hasTooltip() {
        int state = this.getState();
        return super.hasTooltip() || this.tooltip.length > state && !this.tooltip[state].isEmpty();
    }

    @Override
    public void markTooltipDirty() {
        super.markTooltipDirty();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.markDirty();
        }
        this.getState();
    }

    @Override
    @Nullable
    public RichTooltip getTooltip() {
        RichTooltip tooltip = super.getTooltip();
        if (tooltip == null || tooltip.isEmpty()) {
            int state = this.getState();
            if (this.tooltip.length > 0 && this.tooltip.length > state) {
                return this.tooltip[state];
            }
        }
        return tooltip;
    }

    @Override
    public W disableHoverBackground() {
        this.expectCount();
        if (this.hoverBackground != null) {
            Arrays.fill(this.hoverBackground, IDrawable.NONE);
        }
        if (this.getHoverBackground() == null) {
            super.hoverBackground(IDrawable.NONE);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W disableHoverOverlay() {
        this.expectCount();
        if (this.hoverOverlay != null) {
            Arrays.fill(this.hoverOverlay, IDrawable.NONE);
        }
        if (this.getHoverOverlay() == null) {
            super.hoverOverlay(IDrawable.NONE);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W invisible() {
        if (this.background != null) {
            Arrays.fill(this.background, IDrawable.EMPTY);
        }
        if (this.getBackground() == null) {
            super.background(IDrawable.EMPTY);
        }
        return (W)this.disableHoverBackground();
    }

    protected W value(IIntValue<?> value) {
        this.setSyncOrValue(ISyncOrValue.orEmpty(value));
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W child(IWidget child) {
        this.fallbackChild = child;
        return (W)((AbstractCycleButtonWidget)super.child(child));
    }

    public W stateChild(int state, IWidget child) {
        this.updateStateCount(state, false);
        if (this.stateChildren == null) {
            this.stateChildren = new IWidget[state + 1];
        } else if (this.stateChildren.length < state + 1) {
            this.stateChildren = Arrays.copyOf(this.stateChildren, state + 1);
        }
        this.stateChildren[state] = child;
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateBackground(UITexture texture) {
        this.expectCount();
        AbstractCycleButtonWidget.splitTexture(texture, this.background);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateOverlay(UITexture texture) {
        this.expectCount();
        AbstractCycleButtonWidget.splitTexture(texture, this.overlay);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateHoverBackground(UITexture texture) {
        this.expectCount();
        AbstractCycleButtonWidget.splitTexture(texture, this.hoverBackground);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    public W stateHoverOverlay(UITexture texture) {
        this.expectCount();
        AbstractCycleButtonWidget.splitTexture(texture, this.hoverOverlay);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W addTooltip(int state, IDrawable tooltip) {
        this.updateStateCount(state + 1, false);
        this.tooltip[state].addLine(tooltip);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W addTooltip(int state, String tooltip) {
        return this.addTooltip(state, IKey.str(tooltip));
    }

    @Override
    public W addTooltipElement(String s) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.add(s);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipDrawableLines(Iterable<IDrawable> lines) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.addDrawableLines(lines);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipElement(IDrawable drawable) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.add(drawable);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipLine(ITextLine line) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.addLine(line);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipLine(IDrawable drawable) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.addLine(drawable);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W addTooltipStringLines(Iterable<String> lines) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.addStringLines(lines);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipStatic(Consumer<RichTooltip> tooltipConsumer) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltipConsumer.accept(tooltip);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipDynamic(Consumer<RichTooltip> tooltipBuilder) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.tooltipBuilder(tooltipBuilder);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipAlignment(Alignment alignment) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.alignment(alignment);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipPos(RichTooltip.Pos pos) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.pos(pos);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipPos(int x, int y) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.pos(x, y);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipScale(float scale) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.scale(scale);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipTextColor(int textColor) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.textColor(textColor);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipTextShadow(boolean textShadow) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.textShadow(textShadow);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    @Override
    public W tooltipShowUpTimer(int showUpTimer) {
        this.expectCount();
        for (RichTooltip tooltip : this.tooltip) {
            tooltip.showUpTimer(showUpTimer);
        }
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W stateCount(int stateCount) {
        this.updateStateCount(stateCount, true);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    private static IDrawable[] checkArray(IDrawable[] array, int length) {
        if (array == null) {
            return new IDrawable[length];
        }
        return array.length < length ? Arrays.copyOf(array, length) : array;
    }

    protected IDrawable[] addToArray(IDrawable[] array, IDrawable[] drawable, int index) {
        return this.addToArray(array, IDrawable.of(drawable), index);
    }

    protected IDrawable[] addToArray(IDrawable[] array, IDrawable drawable, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.updateStateCount(index + 1, false);
        if (array == null || index >= array.length) {
            IDrawable[] copy = new IDrawable[(int)(Math.ceil((double)(index + 1) / 4.0) * 4.0)];
            if (array != null) {
                System.arraycopy(array, 0, copy, 0, array.length);
            }
            array = copy;
        }
        array[index] = drawable;
        return array;
    }

    protected static void splitTexture(UITexture texture, IDrawable[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            float a = 1.0f / (float)dest.length;
            dest[i] = texture.getSubArea(0.0f, (float)i * a, 1.0f, (float)i * a + a);
        }
    }

    protected W tooltip(int index, Consumer<RichTooltip> builder) {
        this.updateStateCount(index + 1, false);
        builder.accept(this.tooltip[index]);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }

    protected W tooltipBuilder(int index, Consumer<RichTooltip> builder) {
        this.updateStateCount(index + 1, false);
        this.tooltip[index].tooltipBuilder(builder);
        return (W)((AbstractCycleButtonWidget)this.getThis());
    }
}

