/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.wrapper;

import brachy.modularui.api.widget.IFocusedWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ModularScreen;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.widget.EmptyWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.TabOrderedElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WidgetWrapper
extends AbstractWidget {
    private NarratableEntry lastNarratable = null;
    private final IWidget wrapped;
    private final List<WidgetWrapper> children = new ArrayList<WidgetWrapper>();
    private final ModularScreen screen;

    public WidgetWrapper(IWidget wrapped) {
        super(0, 0, 0, 0, CommonComponents.f_237098_);
        this.wrapped = wrapped;
        this.screen = wrapped.getScreen();
        for (IWidget widget : this.wrapped.getChildren()) {
            this.children.add(new WidgetWrapper(widget));
        }
    }

    public int m_252754_() {
        return this.wrapped.getArea().getX();
    }

    public void m_252865_(int x) {
        this.wrapped.getArea().setX(x);
    }

    public int m_252907_() {
        return this.wrapped.getArea().getY();
    }

    public void m_253211_(int y) {
        this.wrapped.getArea().setY(y);
    }

    public void m_264134_(@NotNull Consumer<AbstractWidget> consumer) {
        if (this.wrapped instanceof EmptyWidget) {
            return;
        }
        if (!this.children.isEmpty()) {
            for (WidgetWrapper child : this.children) {
                child.m_264134_(consumer);
            }
        } else {
            super.m_264134_(consumer);
        }
    }

    protected void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ModularGuiContext context = this.screen.getContext();
        GuiGraphics lastGraphics = context.getGraphics();
        context.setGraphics(graphics);
        this.wrapped.draw(context, this.wrapped.getWidgetTheme(context.getTheme()));
        context.setGraphics(lastGraphics);
    }

    protected void m_168797_(@NotNull NarrationElementOutput output) {
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)this.wrapped.getTranslationId()));
        if (!this.wrapped.isEnabled()) {
            return;
        }
        if (this.children.isEmpty()) {
            IFocusedWidget focusable;
            IWidget iWidget = this.wrapped;
            if (iWidget instanceof IFocusedWidget && (focusable = (IFocusedWidget)((Object)iWidget)).isFocused()) {
                output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.focused"));
            } else if (this.wrapped.isHovering()) {
                output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.hovered"));
            }
            return;
        }
        Stream entries = this.children.stream();
        WidgetWrapper.updateNarrations(this.children.stream(), output, this.lastNarratable, entry -> {
            this.lastNarratable = entry;
        });
    }

    public static <T extends NarratableEntry> void updateNarrations(Stream<T> unsorted, NarrationElementOutput output, NarratableEntry lastNarratable, Consumer<NarratableEntry> setter) {
        List entries = unsorted.filter(NarratableEntry::m_142518_).sorted(Comparator.comparingInt(TabOrderedElement::m_267579_)).collect(Collectors.toList());
        Screen.NarratableSearchResult result = Screen.m_169400_(entries, (NarratableEntry)lastNarratable);
        if (result != null) {
            if (result.f_169422_.m_169123_()) {
                setter.accept(result.f_169420_);
            }
            if (entries.size() > 1) {
                output.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.screen", (Object[])new Object[]{result.f_169421_ + 1, entries.size()}));
                if (result.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                    output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                }
            }
            result.f_169420_.m_142291_(output.m_142047_());
        }
    }
}

