/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.sizer;

import brachy.modularui.api.layout.ILayoutWidget;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.ResizeNode;
import java.util.Objects;

public abstract class WidgetResizeNode
extends ResizeNode {
    private final IWidget widget;

    protected WidgetResizeNode(IWidget widget) {
        this.widget = Objects.requireNonNull(widget);
    }

    public IWidget getWidget() {
        return this.widget;
    }

    @Override
    public Area getArea() {
        return this.widget.getArea();
    }

    @Override
    public void initResizing(boolean onOpen) {
        super.initResizing(onOpen);
        this.widget.beforeResize(onOpen);
    }

    @Override
    public void onResized() {
        super.onResized();
        this.widget.onResized();
    }

    @Override
    public void postFullResize() {
        super.postFullResize();
        this.widget.postResize();
    }

    @Override
    public boolean isLayout() {
        return this.widget instanceof ILayoutWidget;
    }

    @Override
    public boolean layoutChildren() {
        IWidget iWidget = this.widget;
        if (iWidget instanceof ILayoutWidget) {
            ILayoutWidget layoutWidget = (ILayoutWidget)((Object)iWidget);
            return layoutWidget.layoutWidgets();
        }
        return true;
    }

    @Override
    public boolean postLayoutChildren() {
        IWidget iWidget = this.widget;
        if (iWidget instanceof ILayoutWidget) {
            ILayoutWidget layoutWidget = (ILayoutWidget)((Object)iWidget);
            return layoutWidget.postLayoutWidgets();
        }
        return true;
    }

    @Override
    public String getDebugDisplayName() {
        return "widget '" + String.valueOf(this.widget) + "' of screen '" + String.valueOf(this.widget.getScreen()) + "'";
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.widget) + ")";
    }
}

