/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.sizer;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.ITreeNode;
import brachy.modularui.api.layout.IResizeable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeNode
implements IResizeable,
ITreeNode<ResizeNode> {
    private ResizeNode defaultParent;
    private ResizeNode parentOverride;
    private final List<ResizeNode> children = new ArrayList<ResizeNode>();
    private boolean defaultParentIsDelegating = false;
    private boolean requiresResize = true;

    @Override
    @ApiStatus.Internal
    public List<ResizeNode> getChildren() {
        return this.children;
    }

    @Override
    public ResizeNode getParent() {
        return this.parentOverride != null ? this.parentOverride : this.defaultParent;
    }

    @ApiStatus.Internal
    public void replacementOf(ResizeNode node) {
        if (this == node) {
            return;
        }
        if (this.defaultParent != null) {
            this.defaultParent.children.remove(this);
        }
        if (this.parentOverride != null) {
            this.parentOverride.children.remove(this);
        }
        for (ResizeNode n : this.children) {
            if (n.parentOverride == this) {
                n.setParentOverride(null);
            }
            if (n.defaultParent != this) continue;
            n.setDefaultParent(null);
        }
        this.children.clear();
        int defI = -1;
        int ovrI = -1;
        if (node.defaultParent != null && (defI = node.defaultParent.children.indexOf(node)) >= 0) {
            node.defaultParent.children.remove(defI);
        }
        if (node.parentOverride != null && (ovrI = node.parentOverride.children.indexOf(node)) >= 0) {
            node.parentOverride.children.remove(ovrI);
        }
        this.defaultParent = node.defaultParent;
        this.parentOverride = node.parentOverride;
        if (this.parentOverride != null) {
            if (ovrI < 0) {
                throw new IllegalStateException();
            }
            this.parentOverride.children.add(ovrI, this);
        }
        if (this.defaultParent != null) {
            if (defI < 0) {
                throw new IllegalStateException();
            }
            this.defaultParent.children.add(ovrI, this);
        }
        this.children.addAll(node.children);
        for (ResizeNode n : this.children) {
            if (n.parentOverride == node) {
                n.parentOverride = this;
            }
            if (n.defaultParent != node) continue;
            n.defaultParent = this;
        }
        node.dispose();
    }

    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().children.remove(this);
        }
        this.defaultParent = null;
        this.parentOverride = null;
        this.children.clear();
    }

    private boolean removeFromParent(ResizeNode parent, ResizeNode parent2, ResizeNode replacement) {
        if (parent != null) {
            if (parent == replacement) {
                return true;
            }
            parent.children.remove(this);
        } else if (parent2 != null) {
            if (parent2 == replacement) {
                return true;
            }
            parent2.children.remove(this);
        }
        return false;
    }

    @ApiStatus.Internal
    public void initialize(ResizeNode defaultParent, ResizeNode root) {
        this.setDefaultParent(defaultParent);
    }

    @ApiStatus.Internal
    public void setDefaultParent(ResizeNode resizeNode) {
        if (resizeNode == this) {
            throw new IllegalArgumentException("Tried to set itself as default parent in " + String.valueOf(this));
        }
        if (this.removeFromParent(this.defaultParent, null, resizeNode)) {
            return;
        }
        this.defaultParent = resizeNode;
        if (this.parentOverride == null && resizeNode != null) {
            resizeNode.children.add(this);
        }
    }

    protected void setParentOverride(ResizeNode resizeNode) {
        if (resizeNode == this) {
            throw new IllegalArgumentException("Tried to set itself as parent override in " + String.valueOf(this));
        }
        if (this.removeFromParent(this.parentOverride, this.defaultParent, resizeNode)) {
            return;
        }
        this.parentOverride = resizeNode;
        if (this.parentOverride != null) {
            this.parentOverride.children.add(this);
        } else if (this.defaultParent != null) {
            this.defaultParent.children.add(this);
        }
    }

    @ApiStatus.Internal
    public void setDefaultParentIsDelegating(boolean defaultParentIsDelegating) {
        this.defaultParentIsDelegating = defaultParentIsDelegating;
    }

    public boolean hasParentOverride() {
        return this.parentOverride != null;
    }

    @Override
    public void initResizing(boolean onOpen) {
        if (this.defaultParentIsDelegating && this.parentOverride != null) {
            this.defaultParent.initResizing(onOpen);
        }
    }

    public void reset() {
    }

    public void markDirty() {
        this.requiresResize = true;
    }

    public void onResized() {
        this.requiresResize = false;
        if (this.defaultParentIsDelegating && this.parentOverride != null) {
            this.defaultParent.onResized();
        }
    }

    public void postFullResize() {
        if (this.defaultParentIsDelegating && this.parentOverride != null) {
            this.defaultParent.postFullResize();
        }
    }

    public boolean requiresResize() {
        return this.requiresResize;
    }

    public boolean dependsOnParentX() {
        return false;
    }

    public boolean dependsOnParentY() {
        return false;
    }

    public boolean dependsOnParent() {
        return this.dependsOnParentX() || this.dependsOnParentY();
    }

    public boolean dependsOnParent(GuiAxis axis) {
        return axis.isHorizontal() ? this.dependsOnParentX() : this.dependsOnParentY();
    }

    public boolean dependsOnChildrenX() {
        return false;
    }

    public boolean dependsOnChildrenY() {
        return false;
    }

    public boolean dependsOnChildren() {
        return this.dependsOnChildrenX() || this.dependsOnChildrenY();
    }

    public boolean dependsOnChildren(GuiAxis axis) {
        return axis.isHorizontal() ? this.dependsOnChildrenX() : this.dependsOnChildrenY();
    }

    public boolean isSameResizer(ResizeNode node) {
        return node == this;
    }

    public boolean isLayout() {
        return false;
    }

    public boolean layoutChildren() {
        return true;
    }

    public boolean postLayoutChildren() {
        return true;
    }

    @ApiStatus.Internal
    public void checkExpanded(@Nullable GuiAxis axis) {
    }

    public abstract boolean hasYPos();

    public abstract boolean hasXPos();

    public abstract boolean hasHeight();

    public abstract boolean hasWidth();

    public abstract boolean hasStartPos(GuiAxis var1);

    public abstract boolean hasEndPos(GuiAxis var1);

    public boolean hasPos(GuiAxis axis) {
        return axis.isHorizontal() ? this.hasXPos() : this.hasYPos();
    }

    public boolean hasSize(GuiAxis axis) {
        return axis.isHorizontal() ? this.hasWidth() : this.hasHeight();
    }

    public boolean isExpanded() {
        return false;
    }

    public abstract boolean isFullSize();

    public abstract boolean hasFixedSize();

    public abstract String getDebugDisplayName();

    public abstract String toString();
}

