/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.sizer;

import brachy.modularui.animation.IAnimatable;
import brachy.modularui.api.GuiAxis;
import brachy.modularui.utils.Interpolations;
import brachy.modularui.utils.serialization.json.JsonHelper;
import com.google.gson.JsonObject;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Box
implements IAnimatable<Box> {
    public static final Box SHARED = new Box();
    public static final Box ZERO = new Box();
    public static final Box ONE = new Box().all(1);
    protected int left;
    protected int top;
    protected int right;
    protected int bottom;

    public Box all(int all) {
        return this.all(all, all);
    }

    public Box all(int horizontal, int vertical) {
        return this.all(horizontal, horizontal, vertical, vertical);
    }

    public Box all(int left, int right, int top, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        return this;
    }

    public Box set(Box box) {
        return this.all(box.left, box.right, box.top, box.bottom);
    }

    public Box set(GuiAxis axis, boolean start, int val) {
        if (axis.isVertical()) {
            if (start) {
                this.top(val);
            } else {
                this.bottom(val);
            }
        } else if (start) {
            this.left(val);
        } else {
            this.right(val);
        }
        return this;
    }

    public int vertical() {
        return this.top + this.bottom;
    }

    public int horizontal() {
        return this.left + this.right;
    }

    public int getTotal(GuiAxis axis) {
        return axis.isHorizontal() ? this.horizontal() : this.vertical();
    }

    public int getStart(GuiAxis axis) {
        return axis.isHorizontal() ? this.left : this.top;
    }

    public int getEnd(GuiAxis axis) {
        return axis.isHorizontal() ? this.right : this.bottom;
    }

    public void fromJson(JsonObject json) {
        this.all(JsonHelper.getInt(json, 0, "margin"));
        if (json.has("marginHorizontal")) {
            this.right = this.left = json.get("marginHorizontal").getAsInt();
        }
        if (json.has("marginVertical")) {
            this.bottom = this.top = json.get("marginVertical").getAsInt();
        }
        this.top = JsonHelper.getInt(json, this.top, "marginTop");
        this.bottom = JsonHelper.getInt(json, this.bottom, "marginBottom");
        this.left = JsonHelper.getInt(json, this.left, "marginLeft");
        this.right = JsonHelper.getInt(json, this.right, "marginRight");
    }

    public void toJson(JsonObject json) {
        json.addProperty("marginTop", (Number)this.top);
        json.addProperty("marginBottom", (Number)this.bottom);
        json.addProperty("marginLeft", (Number)this.left);
        json.addProperty("marginRight", (Number)this.right);
    }

    @Override
    public Box interpolate(Box start, Box end, float t) {
        this.left = Interpolations.lerp(start.left, end.left, t);
        this.top = Interpolations.lerp(start.top, end.top, t);
        this.right = Interpolations.lerp(start.right, end.right, t);
        this.bottom = Interpolations.lerp(start.bottom, end.bottom, t);
        return this;
    }

    @Override
    public Box copyOrImmutable() {
        return new Box().set(this);
    }

    public String toString() {
        return "Box{left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + "}";
    }

    public boolean isEqual(Box box) {
        return this.left == box.left && this.top == box.top && this.right == box.right && this.bottom == box.bottom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.isEqual((Box)o);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.top, this.right, this.bottom);
    }

    @Generated
    public int left() {
        return this.left;
    }

    @NotNull
    @Generated
    public Box left(int left) {
        this.left = left;
        return this;
    }

    @Generated
    public int top() {
        return this.top;
    }

    @NotNull
    @Generated
    public Box top(int top) {
        this.top = top;
        return this;
    }

    @Generated
    public int right() {
        return this.right;
    }

    @NotNull
    @Generated
    public Box right(int right) {
        this.right = right;
        return this;
    }

    @Generated
    public int bottom() {
        return this.bottom;
    }

    @NotNull
    @Generated
    public Box bottom(int bottom) {
        this.bottom = bottom;
        return this;
    }
}

