/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget.scroll;

import brachy.modularui.api.GuiAxis;
import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.screen.viewport.GuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.utils.Color;
import brachy.modularui.widget.scroll.HorizontalScrollData;
import brachy.modularui.widget.scroll.ScrollData;
import brachy.modularui.widget.scroll.ScrollPadding;
import brachy.modularui.widget.scroll.VerticalScrollData;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.Box;
import lombok.Generated;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ScrollArea
extends Area {
    private HorizontalScrollData scrollX;
    private VerticalScrollData scrollY;
    private final ScrollPadding scrollPadding = new ScrollPadding();
    private int scrollBarBackgroundColor;

    public ScrollArea(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.main, 0.25f);
    }

    public ScrollArea() {
        this.scrollBarBackgroundColor = Color.withAlpha(Color.BLACK.main, 0.25f);
    }

    @Override
    public Box getPadding() {
        return this.scrollPadding;
    }

    public ScrollPadding getScrollPadding() {
        return this.scrollPadding;
    }

    public void setScrollData(ScrollData data) {
        if (data instanceof HorizontalScrollData) {
            HorizontalScrollData scrollData;
            this.scrollX = scrollData = (HorizontalScrollData)data;
        } else if (data instanceof VerticalScrollData) {
            VerticalScrollData scrollData;
            this.scrollY = scrollData = (VerticalScrollData)data;
        }
    }

    public void removeScrollData() {
        this.scrollX = null;
        this.scrollY = null;
    }

    public ScrollData getScrollData(GuiAxis axis) {
        return axis.isVertical() ? this.scrollY : this.scrollX;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(GuiContext context) {
        return this.mouseClicked(context.getMouseX(), context.getMouseY());
    }

    public boolean mouseClicked(int x, int y) {
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            return this.scrollX.onMouseClicked(this, x, y, 0);
        }
        if (this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y)) {
            return this.scrollY.onMouseClicked(this, y, x, 0);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseScroll(GuiContext context) {
        return this.mouseScroll(context.getMouseX(), context.getMouseY(), context.getMouseScrollDelta(), Screen.m_96638_());
    }

    public boolean mouseScroll(int x, int y, double scroll, boolean shift) {
        ScrollData data;
        if (this.scrollX != null) {
            data = this.scrollY == null || shift ? this.scrollX : this.scrollY;
        } else if (this.scrollY != null) {
            data = this.scrollY;
        } else {
            return false;
        }
        int scrollAmount = (int)Math.copySign((double)data.getScrollSpeed(), scroll);
        int scrollTo = data.isAnimating() ? data.getAnimatingTo() - scrollAmount : data.getScroll() - scrollAmount;
        int oldScroll = data.getScroll();
        data.scrollTo(this, scrollTo);
        boolean changed = data.getScroll() != oldScroll;
        data.scrollTo(this, oldScroll);
        if (changed) {
            data.animateTo(this, scrollTo);
            return true;
        }
        return data.isCancelScrollEdge();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseReleased(GuiContext context) {
        this.mouseReleased(context.getMouseX(), context.getMouseY());
    }

    public void mouseReleased(int x, int y) {
        if (this.scrollX != null) {
            this.scrollX.dragging = false;
            this.scrollX.clickOffset = 0;
        }
        if (this.scrollY != null) {
            this.scrollY.dragging = false;
            this.scrollY.clickOffset = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drag(GuiContext context) {
        this.drag(context.getMouseX(), context.getMouseY());
    }

    public void drag(int x, int y) {
        float progress;
        ScrollData data;
        if (this.scrollX != null && this.scrollX.dragging) {
            data = this.scrollX;
            progress = data.getProgress(this, x, y);
        } else if (this.scrollY != null && this.scrollY.dragging) {
            data = this.scrollY;
            progress = data.getProgress(this, y, x);
        } else {
            return;
        }
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        data.scrollTo(this, (int)(progress * (float)(data.getScrollSize() - data.getFullVisibleSize(this) + data.getThickness())));
    }

    public boolean isInsideScrollbarArea(int x, int y) {
        if (!this.isInside(x, y)) {
            return false;
        }
        if (this.scrollX != null && this.scrollX.isInsideScrollbarArea(this, x, y)) {
            return true;
        }
        return this.scrollY != null && this.scrollY.isInsideScrollbarArea(this, x, y);
    }

    public boolean isScrollBarXActive() {
        return this.scrollX != null && this.scrollX.isScrollBarActive(this);
    }

    public boolean isScrollBarYActive() {
        return this.scrollY != null && this.scrollY.isScrollBarActive(this);
    }

    public boolean isDragging() {
        return this.scrollX != null && this.scrollX.isDragging() || this.scrollY != null && this.scrollY.isDragging();
    }

    public void applyWidgetTheme(WidgetTheme widgetTheme) {
        if (this.scrollX != null) {
            this.scrollX.applyWidgetTheme(widgetTheme);
        }
        if (this.scrollY != null) {
            this.scrollY.applyWidgetTheme(widgetTheme);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawScrollbar(GuiContext context, WidgetTheme widgetTheme, IDrawable texture) {
        boolean isXActive = false;
        if (this.scrollX != null && this.scrollX.isScrollBarActive(this, false)) {
            isXActive = true;
            this.scrollX.drawScrollbar(context, this, widgetTheme, texture);
        }
        if (this.scrollY != null && this.scrollY.isScrollBarActive(this, isXActive)) {
            this.scrollY.drawScrollbar(context, this, widgetTheme, texture);
        }
    }

    @Generated
    public HorizontalScrollData getScrollX() {
        return this.scrollX;
    }

    @NotNull
    @Generated
    public ScrollArea setScrollX(HorizontalScrollData scrollX) {
        this.scrollX = scrollX;
        return this;
    }

    @Generated
    public VerticalScrollData getScrollY() {
        return this.scrollY;
    }

    @NotNull
    @Generated
    public ScrollArea setScrollY(VerticalScrollData scrollY) {
        this.scrollY = scrollY;
        return this;
    }

    @Generated
    public int getScrollBarBackgroundColor() {
        return this.scrollBarBackgroundColor;
    }

    @NotNull
    @Generated
    public ScrollArea setScrollBarBackgroundColor(int scrollBarBackgroundColor) {
        this.scrollBarBackgroundColor = scrollBarBackgroundColor;
        return this;
    }
}

