/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.layout.IViewport;
import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IDraggable;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.utils.HoveredWidgetList;
import brachy.modularui.widget.Widget;
import brachy.modularui.widget.WidgetTree;
import brachy.modularui.widget.sizer.Area;
import brachy.modularui.widget.sizer.StandardResizer;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;

public class DraggableWidget<W extends DraggableWidget<W>>
extends Widget<W>
implements IDraggable,
IViewport {
    private boolean moving = false;
    private int relativeClickX;
    private int relativeClickY;
    private final Area movingArea = this.getArea().createCopy();
    private int realX;
    private int realY;

    @Override
    public void drawMovingState(GuiGraphics graphics, ModularGuiContext context, float partialTicks) {
        WidgetTree.drawTree(this, context, true, true);
    }

    @Override
    public boolean onDragStart(int mouseButton) {
        if (mouseButton == 0) {
            this.realX = this.getContext().transformX(0.0f, 0.0f) - this.getParentArea().x;
            this.realY = this.getContext().transformY(0.0f, 0.0f) - this.getParentArea().y;
            this.movingArea.x = this.realX;
            this.movingArea.y = this.realY;
            this.relativeClickX = this.getContext().getAbsMouseX() - this.realX;
            this.relativeClickY = this.getContext().getAbsMouseY() - this.realY;
            return true;
        }
        return false;
    }

    @Override
    public void onDragEnd(boolean successful) {
        if (successful) {
            ((StandardResizer)this.resizer().top(this.getContext().getAbsMouseY() - this.relativeClickY)).left(this.getContext().getAbsMouseX() - this.relativeClickX);
            this.movingArea.x = this.getArea().x;
            this.movingArea.y = this.getArea().y;
            this.scheduleResize();
        }
    }

    @Override
    public void onDrag(int mouseButton, double timeSinceLastClick) {
        this.movingArea.x = this.getContext().getAbsMouseX() - this.relativeClickX;
        this.movingArea.y = this.getContext().getAbsMouseY() - this.relativeClickY;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
        this.setEnabled(!moving);
    }

    @Override
    public void getSelfAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (!this.isMoving() && this.isInside(stack, x, y)) {
            widgets.add(this, stack, this.getAdditionalHoverInfo(stack, x, y));
        }
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (!this.isMoving() && this.hasChildren()) {
            IViewport.getChildrenAt(this, stack, widgets, x, y);
        }
    }

    @Override
    public void transform(IViewportStack stack) {
        super.transform(stack);
        if (this.isMoving()) {
            stack.translate(-this.getArea().rx, -this.getArea().ry);
            stack.translate(-this.realX, -this.realY);
            stack.translate(this.movingArea.x, this.movingArea.y);
        }
    }

    @Override
    @Generated
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    @Generated
    public Area getMovingArea() {
        return this.movingArea;
    }
}

