/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.layout.IViewport;
import brachy.modularui.api.layout.IViewportStack;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.api.widget.Interactable;
import brachy.modularui.screen.viewport.ModularGuiContext;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.utils.HoveredWidgetList;
import brachy.modularui.widget.AbstractParentWidget;
import brachy.modularui.widget.scroll.HorizontalScrollData;
import brachy.modularui.widget.scroll.ScrollArea;
import brachy.modularui.widget.scroll.ScrollData;
import brachy.modularui.widget.scroll.VerticalScrollData;
import brachy.modularui.widget.sizer.Area;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScrollWidget<I extends IWidget, W extends AbstractScrollWidget<I, W>>
extends AbstractParentWidget<I, W>
implements IViewport,
Interactable {
    private final ScrollArea scroll = new ScrollArea();
    private boolean scrollXActive;
    private boolean scrollYActive;

    public AbstractScrollWidget(@Nullable HorizontalScrollData x, @Nullable VerticalScrollData y) {
        this.scroll.setScrollX(x);
        this.scroll.setScrollY(y);
        this.listenGuiAction((mouseX, mouseY, button) -> {
            this.scroll.mouseReleased(this.getContext());
            return false;
        });
    }

    @Override
    public Area getArea() {
        return this.scroll;
    }

    public ScrollArea getScrollArea() {
        return this.scroll;
    }

    @Override
    public void transformChildren(IViewportStack stack) {
        stack.translate(-this.getScrollX(), -this.getScrollY());
    }

    @Override
    public void getWidgetsAt(IViewportStack stack, HoveredWidgetList widgets, int x, int y) {
        if (widgets.peek() == this && !this.getScrollArea().isInsideScrollbarArea(x, y)) {
            IViewport.super.getWidgetsAt(stack, widgets, x, y);
        }
    }

    @Override
    public void beforeResize(boolean onOpen) {
        super.beforeResize(onOpen);
        this.scroll.applyWidgetTheme(this.getPanel().getTheme().getScrollbarTheme().getTheme(this.isHovering()));
        if (onOpen) {
            this.checkScrollbarActive(true);
        }
        this.getScrollArea().getScrollPadding().scrollPaddingAll(0);
        this.applyAdditionalOffset(this.scroll.getScrollX());
        this.applyAdditionalOffset(this.scroll.getScrollY());
    }

    private void checkScrollbarActive(boolean onOpen) {
        boolean scrollXActive;
        boolean scrollYActive = this.scroll.getScrollY() != null && this.scroll.getScrollY().isScrollBarActive(this.getScrollArea());
        boolean bl = scrollXActive = this.scroll.getScrollX() != null && this.scroll.getScrollX().isScrollBarActive(this.getScrollArea(), this.scrollYActive);
        if (!(onOpen || scrollYActive == this.scrollYActive && scrollXActive == this.scrollXActive)) {
            this.scheduleResize();
        }
        this.scrollXActive = scrollXActive;
        this.scrollYActive = scrollYActive;
    }

    private void applyAdditionalOffset(ScrollData data) {
        if (data != null && data.isScrollBarActive(this.getScrollArea())) {
            this.getScrollArea().getScrollPadding().scrollPadding(data.getAxis().getOther(), data.isAxisStart(), data.getThickness());
        }
    }

    @Override
    public boolean canHover() {
        return super.canHover() || this.scroll.isInsideScrollbarArea(this.getContext().getMouseX(), this.getContext().getMouseY());
    }

    @Override
    @NotNull
    public Interactable.Result onMousePressed(double mouseX, double mouseY, int button) {
        ModularGuiContext context = this.getContext();
        if (this.scroll.mouseClicked(context)) {
            return Interactable.Result.SUCCESS;
        }
        return Interactable.Result.IGNORE;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double delta) {
        return this.scroll.mouseScroll(this.getContext());
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        this.scroll.mouseReleased(this.getContext());
        return false;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.checkScrollbarActive(false);
        this.scroll.drag(this.getContext().getMouseX(), this.getContext().getMouseY());
    }

    @Override
    public void preDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            context.getStencil().pushAtZero(this.scroll);
        }
    }

    @Override
    public void postDraw(ModularGuiContext context, boolean transformed) {
        if (!transformed) {
            context.getStencil().pop();
            WidgetThemeEntry<WidgetTheme> scrollbarTheme = this.getPanel().getTheme().getScrollbarTheme();
            this.scroll.drawScrollbar(context, scrollbarTheme.getTheme(this.isHovering()), scrollbarTheme.theme().getBackground());
        }
    }

    public int getScrollX() {
        return this.scroll.getScrollX() != null ? this.scroll.getScrollX().getScroll() : 0;
    }

    public int getScrollY() {
        return this.scroll.getScrollY() != null ? this.scroll.getScrollY().getScroll() : 0;
    }
}

