/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.widget;

import brachy.modularui.api.drawable.IDrawable;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.screen.ModularPanel;
import brachy.modularui.theme.WidgetTheme;
import brachy.modularui.theme.WidgetThemeEntry;
import brachy.modularui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class AbstractParentWidget<I extends IWidget, W extends AbstractParentWidget<I, W>>
extends Widget<W> {
    private final List<I> children = new ArrayList<I>();

    @Override
    public @UnmodifiableView @NotNull List<IWidget> getChildren() {
        return this.children;
    }

    public @UnmodifiableView List<I> getTypeChildren() {
        return this.children;
    }

    @Override
    public boolean canHover() {
        if (IDrawable.isVisible(this.getBackground()) || IDrawable.isVisible(this.getHoverBackground()) || IDrawable.isVisible(this.getHoverOverlay()) || this.getTooltip() != null) {
            return true;
        }
        WidgetThemeEntry<?> widgetTheme = this.getWidgetTheme(this.getPanel().getTheme());
        if (this.getBackground() == null && IDrawable.isVisible(((WidgetTheme)widgetTheme.theme()).getBackground())) {
            return true;
        }
        return this.getHoverBackground() == null && IDrawable.isVisible(((WidgetTheme)widgetTheme.hoverTheme()).getBackground());
    }

    @Override
    public boolean canClickThrough() {
        return !this.canHover();
    }

    @Override
    public boolean canHoverThrough() {
        return !this.canHover();
    }

    protected boolean addChild(I child, int index) {
        if (child == null || child == this || this.getChildren().contains(child)) {
            return false;
        }
        if (child instanceof ModularPanel) {
            throw new IllegalArgumentException("ModularPanel should not be added as child widget; Use ModularScreen#openPanel instead");
        }
        if (!this.isChildValid(child)) {
            throw new IllegalArgumentException("Child '" + String.valueOf(child) + "' is not valid for parent '" + String.valueOf(this) + "'!");
        }
        if (index < 0) {
            index += this.getChildren().size() + 1;
        }
        this.children.add(index, child);
        if (this.isValid()) {
            child.initialise(this, true);
        }
        this.onChildAdd(child);
        return true;
    }

    protected boolean remove(I child) {
        if (this.children.remove(child)) {
            if (this.isValid()) {
                child.dispose();
            }
            this.onChildRemove(child);
            return true;
        }
        return false;
    }

    protected boolean remove(int index) {
        IWidget child;
        if (index < 0) {
            index = this.getChildren().size() + index + 1;
        }
        if (this.isChildValid(child = (IWidget)this.children.remove(index))) {
            child.dispose();
        }
        this.onChildRemove(child);
        return true;
    }

    protected boolean removeAll() {
        if (this.children.isEmpty()) {
            return false;
        }
        for (IWidget i : this.children) {
            if (this.isValid()) {
                i.dispose();
            }
            this.onChildRemove(i);
        }
        this.children.clear();
        return true;
    }

    protected boolean isChildValid(I child) {
        return true;
    }

    protected void onChildAdd(I child) {
    }

    protected void onChildRemove(I child) {
    }
}

