/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.api.IPacketWriter;
import brachy.modularui.api.value.ISyncOrValue;
import brachy.modularui.network.ModularNetwork;
import brachy.modularui.network.ModularNetworkSide;
import brachy.modularui.value.sync.PanelSyncManager;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;

public abstract class SyncHandler
implements ISyncOrValue {
    private PanelSyncManager syncManager;
    private String key;

    @ApiStatus.OverrideOnly
    @MustBeInvokedByOverriders
    public void init(String key, PanelSyncManager syncManager) {
        this.key = key;
        this.syncManager = syncManager;
    }

    @ApiStatus.OverrideOnly
    @MustBeInvokedByOverriders
    public void dispose() {
        this.key = null;
        this.syncManager = null;
    }

    public final void syncToClient(int id, @NotNull IPacketWriter bufferConsumer) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130130_(id);
        bufferConsumer.write(buffer);
        SyncHandler.sendToClient(this.getSyncManager().getPanelName(), buffer, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void syncToServer(int id, @NotNull IPacketWriter bufferConsumer) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130130_(id);
        bufferConsumer.write(buffer);
        SyncHandler.sendToServer(this.getSyncManager().getPanelName(), buffer, this);
    }

    public final void sync(int id, @NotNull IPacketWriter bufferConsumer) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130130_(id);
        bufferConsumer.write(buffer);
        SyncHandler.send(ModularNetwork.get(this.getSyncManager().isClient()), this.getSyncManager().getPanelName(), buffer, this);
    }

    public final void syncToClient(int id) {
        this.syncToClient(id, buf -> {});
    }

    public final void syncToServer(int id) {
        this.syncToServer(id, buf -> {});
    }

    public final void sync(int id) {
        this.sync(id, buf -> {});
    }

    @OnlyIn(value=Dist.CLIENT)
    @ApiStatus.OverrideOnly
    public abstract void readOnClient(int var1, FriendlyByteBuf var2);

    @ApiStatus.OverrideOnly
    public abstract void readOnServer(int var1, FriendlyByteBuf var2);

    public void detectAndSendChanges(boolean init) {
    }

    public final boolean isValid() {
        return this.key != null && this.syncManager != null;
    }

    public PanelSyncManager getSyncManager() {
        if (!this.isValid()) {
            throw new IllegalStateException("Sync handler is not yet initialised!");
        }
        return this.syncManager;
    }

    public final boolean isRegistered() {
        return this.isValid() && this.syncManager.hasSyncHandler(this);
    }

    @Override
    public boolean isSyncHandler() {
        return true;
    }

    private static void send(ModularNetworkSide network, String panel, FriendlyByteBuf buffer, SyncHandler syncHandler) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(syncHandler);
        if (!syncHandler.isValid()) {
            throw new IllegalStateException("Not initialized sync handlers can't send packets!");
        }
        network.sendSyncHandlerPacket(panel, syncHandler, buffer, syncHandler.syncManager.getPlayer());
    }

    public static void sendToClient(String panel, FriendlyByteBuf buffer, SyncHandler syncHandler) {
        SyncHandler.send(ModularNetwork.SERVER, panel, buffer, syncHandler);
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(String panel, FriendlyByteBuf buffer, SyncHandler syncHandler) {
        SyncHandler.send(ModularNetwork.CLIENT, panel, buffer, syncHandler);
    }

    @Generated
    public String getKey() {
        return this.key;
    }
}

