/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.utils.MouseData;
import brachy.modularui.value.sync.ItemSlotSyncHandler;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.widgets.slot.ModularSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.ApiStatus;

public class PhantomItemSlotSyncHandler
extends ItemSlotSyncHandler {
    public static final int SYNC_CLICK = 100;
    public static final int SYNC_SCROLL = 101;
    public static final int SYNC_ITEM_SIMPLE = 102;
    private ItemStack lastStoredPhantomItem = ItemStack.f_41583_;

    @ApiStatus.Internal
    public PhantomItemSlotSyncHandler(ModularSlot slot) {
        super(slot);
        ((Slot)slot).f_40219_ = -1;
    }

    @Override
    public void init(String key, PanelSyncManager syncHandler) {
        super.init(key, syncHandler);
        if (this.isPhantom() && !this.getSlot().m_7993_().m_41619_()) {
            this.lastStoredPhantomItem = this.getSlot().m_7993_().m_41777_();
            this.lastStoredPhantomItem.m_41764_(1);
        }
    }

    @Override
    protected void onSlotUpdate(ItemStack stack, boolean onlyAmountChanged, boolean client, boolean init) {
        this.getSlot().m_5852_(stack);
        if (!onlyAmountChanged && !stack.m_41619_()) {
            this.lastStoredPhantomItem = stack.m_41777_();
            this.lastStoredPhantomItem.m_41764_(1);
        }
        super.onSlotUpdate(stack, onlyAmountChanged, client, init);
    }

    @Override
    public void readOnServer(int id, FriendlyByteBuf buf) {
        super.readOnServer(id, buf);
        if (id == 100) {
            this.phantomClick(MouseData.readPacket(buf));
        } else if (id == 101) {
            this.phantomScroll(MouseData.readPacket(buf));
        } else if (id == 102) {
            if (!this.isPhantom()) {
                return;
            }
            this.phantomClick(new MouseData(Dist.DEDICATED_SERVER, 0, false, false, false), buf.m_130267_());
        }
    }

    public void updateFromClient(ItemStack stack) {
        this.syncToServer(102, buf -> buf.m_130055_(stack));
    }

    protected void phantomClick(MouseData mouseData) {
        this.phantomClick(mouseData, this.getSyncManager().getCursorItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void phantomClick(MouseData mouseData, ItemStack cursorStack) {
        ItemStack slotStack = this.getSlot().m_7993_();
        if (!(cursorStack.m_41619_() || slotStack.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)cursorStack, (ItemStack)slotStack))) {
            if (!this.isItemValid(cursorStack)) {
                return;
            }
            ItemStack stackToPut = cursorStack.m_41777_();
            if (mouseData.mouseButton() == 1) {
                stackToPut.m_41764_(1);
            }
            stackToPut.m_41764_(Math.min(stackToPut.m_41613_(), this.getSlot().m_5866_(stackToPut)));
            this.getSlot().m_5852_(stackToPut);
            this.lastStoredPhantomItem = stackToPut.m_41777_();
            return;
        } else if (slotStack.m_41619_()) {
            ItemStack stackToPut;
            if (cursorStack.m_41619_()) {
                if (mouseData.mouseButton() != 1 || this.lastStoredPhantomItem.m_41619_()) return;
                stackToPut = this.lastStoredPhantomItem.m_41777_();
            } else {
                if (!this.isItemValid(cursorStack)) {
                    return;
                }
                stackToPut = cursorStack.m_41777_();
            }
            if (mouseData.mouseButton() == 1) {
                stackToPut.m_41764_(1);
            }
            stackToPut.m_41764_(Math.min(stackToPut.m_41613_(), this.getSlot().m_5866_(stackToPut)));
            this.getSlot().m_5852_(stackToPut);
            this.lastStoredPhantomItem = stackToPut.m_41777_();
            return;
        } else if (mouseData.mouseButton() == 0) {
            if (mouseData.shift()) {
                this.getSlot().m_5852_(ItemStack.f_41583_);
                return;
            } else {
                this.incrementStackCount(-1);
            }
            return;
        } else {
            if (mouseData.mouseButton() != 1) return;
            this.incrementStackCount(1);
        }
    }

    protected void phantomScroll(MouseData mouseData) {
        ItemStack currentItem = this.getSlot().m_7993_();
        int amount = mouseData.mouseButton();
        if (mouseData.shift()) {
            amount *= 4;
        }
        if (mouseData.ctrl()) {
            amount *= 16;
        }
        if (mouseData.alt()) {
            amount *= 64;
        }
        if (amount > 0 && currentItem.m_41619_() && !this.lastStoredPhantomItem.m_41619_()) {
            ItemStack stackToPut = this.lastStoredPhantomItem.m_41777_();
            stackToPut.m_41764_(amount);
            this.getSlot().m_5852_(stackToPut);
        } else {
            this.incrementStackCount(amount);
        }
    }

    public void incrementStackCount(int amount) {
        ItemStack stack = this.getSlot().m_7993_();
        if (stack.m_41619_()) {
            return;
        }
        int oldAmount = stack.m_41613_();
        if (amount < 0) {
            amount = Math.max(0, oldAmount + amount);
        } else if (Integer.MAX_VALUE - amount < oldAmount) {
            amount = Integer.MAX_VALUE;
        } else {
            int maxSize = this.getSlot().m_6641_();
            if (!this.getSlot().isIgnoreMaxStackSize() && stack.m_41741_() < maxSize) {
                maxSize = stack.m_41741_();
            }
            amount = Math.min(oldAmount + amount, maxSize);
        }
        if (oldAmount != amount) {
            stack = stack.m_41777_();
            stack.m_41764_(amount);
            this.getSlot().m_5852_(stack);
        }
    }

    @Override
    public boolean isPhantom() {
        return true;
    }
}

