/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.ModularUI;
import brachy.modularui.api.value.sync.IDoubleSyncValue;
import brachy.modularui.api.value.sync.IIntSyncValue;
import brachy.modularui.api.value.sync.IStringSyncValue;
import brachy.modularui.value.sync.ValueSyncHandler;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntSyncValue
extends ValueSyncHandler<Integer>
implements IIntSyncValue<Integer>,
IDoubleSyncValue<Integer>,
IStringSyncValue<Integer> {
    private int cache;
    private final IntSupplier getter;
    private final IntConsumer setter;

    public IntSyncValue(@NotNull IntSupplier getter, @Nullable IntConsumer setter) {
        this.getter = Objects.requireNonNull(getter);
        this.setter = setter;
        this.cache = getter.getAsInt();
    }

    public IntSyncValue(@NotNull IntSupplier getter) {
        this(getter, (IntConsumer)null);
    }

    @Contract(value="null, null -> fail")
    public IntSyncValue(@Nullable IntSupplier clientGetter, @Nullable IntSupplier serverGetter) {
        this(clientGetter, null, serverGetter, null);
    }

    @Contract(value="null, _, null, _ -> fail")
    public IntSyncValue(@Nullable IntSupplier clientGetter, @Nullable IntConsumer clientSetter, @Nullable IntSupplier serverGetter, @Nullable IntConsumer serverSetter) {
        if (clientGetter == null && serverGetter == null) {
            throw new NullPointerException("Client or server getter must not be null!");
        }
        if (ModularUI.isClientThread()) {
            this.getter = clientGetter != null ? clientGetter : serverGetter;
            this.setter = clientSetter != null ? clientSetter : serverSetter;
        } else {
            this.getter = serverGetter != null ? serverGetter : clientGetter;
            this.setter = serverSetter != null ? serverSetter : clientSetter;
        }
        this.cache = this.getter.getAsInt();
    }

    @Override
    public Integer getValue() {
        return this.cache;
    }

    @Override
    public int getIntValue() {
        return this.cache;
    }

    @Override
    public void setValue(Integer value, boolean setSource, boolean sync) {
        this.setIntValue(value, setSource, sync);
    }

    @Override
    public void setIntValue(int value, boolean setSource, boolean sync) {
        this.cache = value;
        if (setSource && this.setter != null) {
            this.setter.accept(value);
        }
        this.onValueChanged();
        if (sync) {
            this.sync();
        }
    }

    @Override
    public void setDoubleValue(double value, boolean setSource, boolean sync) {
        this.setIntValue((int)value, setSource, sync);
    }

    @Override
    public double getDoubleValue() {
        return this.cache;
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.getter.getAsInt() != this.cache) {
            this.setIntValue(this.getter.getAsInt(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void notifyUpdate() {
        this.setIntValue(this.getter.getAsInt(), false, true);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.cache);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setIntValue(buffer.m_130242_(), true, false);
    }

    @Override
    public void setStringValue(String value, boolean setSource, boolean sync) {
        this.setIntValue(Integer.parseInt(value), setSource, sync);
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.cache);
    }

    @Override
    public Class<Integer> getValueType() {
        return Integer.class;
    }
}

