/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.api.IPanelHandler;
import brachy.modularui.api.ISyncedAction;
import brachy.modularui.value.sync.DynamicSyncHandler;
import brachy.modularui.value.sync.ItemSlotSyncHandler;
import brachy.modularui.value.sync.PanelSyncHandler;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.value.sync.SyncHandler;
import brachy.modularui.widgets.slot.ModularSlot;
import brachy.modularui.widgets.slot.PlayerSlotGroup;
import brachy.modularui.widgets.slot.SlotGroup;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISyncRegistrar<S extends ISyncRegistrar<S>> {
    public boolean hasSyncHandler(SyncHandler var1);

    default public S syncValue(String name, SyncHandler syncHandler) {
        return this.syncValue(name, 0, syncHandler);
    }

    public S syncValue(String var1, int var2, SyncHandler var3);

    default public S syncValue(int id, SyncHandler syncHandler) {
        return this.syncValue("_", id, syncHandler);
    }

    default public S itemSlot(String key, ModularSlot slot) {
        return this.itemSlot(key, 0, slot);
    }

    default public S itemSlot(String key, int id, ModularSlot slot) {
        return this.syncValue(key, id, new ItemSlotSyncHandler(slot));
    }

    default public S itemSlot(int id, ModularSlot slot) {
        return this.itemSlot("_", id, slot);
    }

    default public DynamicSyncHandler dynamicSyncHandler(String key, DynamicSyncHandler.IWidgetProvider widgetProvider) {
        return this.dynamicSyncHandler(key, 0, widgetProvider);
    }

    default public DynamicSyncHandler dynamicSyncHandler(String key, int id, DynamicSyncHandler.IWidgetProvider widgetProvider) {
        DynamicSyncHandler syncHandler = new DynamicSyncHandler().widgetProvider(widgetProvider);
        this.syncValue(key, id, syncHandler);
        return syncHandler;
    }

    public IPanelHandler syncedPanel(String var1, boolean var2, PanelSyncHandler.IPanelBuilder var3);

    @Nullable
    public IPanelHandler findPanelHandlerNullable(String var1);

    @NotNull
    default public IPanelHandler findPanelHandler(String key) {
        IPanelHandler panelHandler = this.findPanelHandlerNullable(key);
        if (panelHandler == null) {
            throw new NoSuchElementException("Expected to find panel sync handler with key '" + key + "', but none was found.");
        }
        return panelHandler;
    }

    public S registerSlotGroup(SlotGroup var1);

    default public S registerSlotGroup(String name, int rowSize, int shiftClickPriority) {
        return this.registerSlotGroup(new SlotGroup(name, rowSize, shiftClickPriority, true));
    }

    default public S registerSlotGroup(String name, int rowSize, boolean allowShiftTransfer) {
        return this.registerSlotGroup(new SlotGroup(name, rowSize, 100, allowShiftTransfer));
    }

    default public S registerSlotGroup(String name, int rowSize) {
        return this.registerSlotGroup(new SlotGroup(name, rowSize, 100, true));
    }

    default public S bindPlayerInventory(Player player) {
        return this.bindPlayerInventory(player, ModularSlot::new);
    }

    default public S bindPlayerInventory(Player player, @NotNull PanelSyncManager.SlotFunction slotFunction) {
        if (this.getSlotGroup("player_inventory") != null) {
            throw new IllegalStateException("The player slot group is already registered!");
        }
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.m_150109_());
        String key = "player";
        for (int i = 0; i < 36; ++i) {
            this.itemSlot(key, i, slotFunction.apply(playerInventory, i).slotGroup("player_inventory"));
        }
        this.registerSlotGroup(new PlayerSlotGroup("player_inventory"));
        return (S)this;
    }

    default public S registerSyncedAction(String mapKey, ISyncedAction action) {
        return this.registerSyncedAction(mapKey, true, true, action);
    }

    default public S registerSyncedAction(String mapKey, Side side, ISyncedAction action) {
        return this.registerSyncedAction(mapKey, side.isClient(), side.isServer(), action);
    }

    default public S registerClientSyncedAction(String mapKey, ISyncedAction action) {
        return this.registerSyncedAction(mapKey, true, false, action);
    }

    default public S registerServerSyncedAction(String mapKey, ISyncedAction action) {
        return this.registerSyncedAction(mapKey, false, true, action);
    }

    public S registerSyncedAction(String var1, boolean var2, boolean var3, ISyncedAction var4);

    default public <T extends SyncHandler> T getOrCreateSyncHandler(String name, Class<T> clazz, Supplier<T> supplier) {
        return this.getOrCreateSyncHandler(name, 0, clazz, supplier);
    }

    public <T extends SyncHandler> T getOrCreateSyncHandler(String var1, int var2, Class<T> var3, Supplier<T> var4);

    default public ItemSlotSyncHandler getOrCreateSlot(String name, int id, Supplier<ModularSlot> slotSupplier) {
        return this.getOrCreateSyncHandler(name, id, ItemSlotSyncHandler.class, () -> new ItemSlotSyncHandler((ModularSlot)((Object)((Object)slotSupplier.get()))));
    }

    @Nullable
    public SyncHandler findSyncHandlerNullable(String var1, int var2);

    @Nullable
    default public SyncHandler findSyncHandlerNullable(String name) {
        return this.findSyncHandlerNullable(name, 0);
    }

    @NotNull
    default public SyncHandler findSyncHandler(String name, int id) {
        SyncHandler syncHandler = this.findSyncHandlerNullable(name, id);
        if (syncHandler == null) {
            throw new NoSuchElementException("Expected to find sync handler with key '" + ISyncRegistrar.makeSyncKey(name, id) + "', but none was found.");
        }
        return syncHandler;
    }

    @NotNull
    default public SyncHandler findSyncHandler(String name) {
        return this.findSyncHandler(name, 0);
    }

    @Nullable
    default public <T extends SyncHandler> T findSyncHandlerNullable(String name, int id, Class<T> type) {
        SyncHandler syncHandler = this.findSyncHandlerNullable(name, id);
        if (syncHandler != null && type.isAssignableFrom(syncHandler.getClass())) {
            return (T)((SyncHandler)type.cast(syncHandler));
        }
        return null;
    }

    @Nullable
    default public <T extends SyncHandler> T findSyncHandlerNullable(String name, Class<T> type) {
        return this.findSyncHandlerNullable(name, 0, type);
    }

    @NotNull
    default public <T extends SyncHandler> T findSyncHandler(String name, int id, Class<T> type) {
        SyncHandler syncHandler = this.findSyncHandlerNullable(name, id);
        if (syncHandler == null) {
            throw new NoSuchElementException("Expected to find sync handler with key '" + ISyncRegistrar.makeSyncKey(name, id) + "', but none was found.");
        }
        if (!type.isAssignableFrom(syncHandler.getClass())) {
            throw new ClassCastException("Expected to find sync handler with key '" + ISyncRegistrar.makeSyncKey(name, id) + "' of type '" + type.getName() + "', but found type '" + syncHandler.getClass().getName() + "'.");
        }
        return (T)((SyncHandler)type.cast(syncHandler));
    }

    @NotNull
    default public <T extends SyncHandler> T findSyncHandler(String name, Class<T> type) {
        return this.findSyncHandler(name, 0, type);
    }

    public SlotGroup getSlotGroup(String var1);

    public static String makeSyncKey(String name, int id) {
        return name + ":" + id;
    }
}

