/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.api.IPacketWriter;
import brachy.modularui.api.widget.IWidget;
import brachy.modularui.value.sync.IDynamicSyncNotifiable;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.value.sync.SyncHandler;
import brachy.modularui.widget.WidgetTree;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Obsolete
public class DynamicSyncHandler
extends SyncHandler
implements IDynamicSyncNotifiable {
    private IWidgetProvider widgetProvider;
    private Consumer<IWidget> onWidgetUpdate;
    private IPacketWriter lastRejectedPacket;
    private IWidget lastRejectedWidget;

    @Override
    public void readOnClient(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            this.updateWidget(this.parseWidget(buf));
        }
    }

    @Override
    public void readOnServer(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            this.parseWidget(buf);
        }
    }

    @Override
    public void init(String key, PanelSyncManager syncManager) {
        super.init(key, syncManager);
        if (this.lastRejectedPacket != null) {
            this.notifyUpdate(this.lastRejectedPacket);
            this.lastRejectedPacket = null;
        }
    }

    private IWidget parseWidget(FriendlyByteBuf buf) {
        this.getSyncManager().allowTemporarySyncHandlerRegistration(true);
        IWidget widget = this.widgetProvider.createWidget(this.getSyncManager(), buf);
        this.getSyncManager().allowTemporarySyncHandlerRegistration(false);
        int unregistered = WidgetTree.countUnregisteredSyncHandlers(widget);
        if (unregistered > 0) {
            throw new IllegalStateException("Widgets created by DynamicSyncHandler can't have implicitly registered sync handlers. All sync handlers must be regisered witha  variant of 'PanelSyncManager#getOrCreateSyncHandler(...)'.");
        }
        return widget;
    }

    private void updateWidget(IWidget widget) {
        if (this.onWidgetUpdate == null) {
            this.lastRejectedWidget = widget;
        } else {
            this.onWidgetUpdate.accept(widget);
        }
    }

    public void notifyUpdate(IPacketWriter packetWriter) {
        if (!this.isValid()) {
            this.lastRejectedPacket = packetWriter;
            return;
        }
        IWidget widget = this.parseWidget(packetWriter.toPacket());
        if (this.getSyncManager().isClient()) {
            this.updateWidget(widget);
        }
        this.sync(0, packetWriter);
    }

    public DynamicSyncHandler widgetProvider(IWidgetProvider widgetProvider) {
        this.widgetProvider = widgetProvider;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public void attachDynamicWidgetListener(Consumer<IWidget> onWidgetUpdate) {
        this.onWidgetUpdate = onWidgetUpdate;
        if (this.onWidgetUpdate != null && this.lastRejectedWidget != null) {
            this.onWidgetUpdate.accept(this.lastRejectedWidget);
            this.lastRejectedWidget = null;
        }
    }

    public static interface IWidgetProvider {
        @Nullable
        public IWidget createWidget(PanelSyncManager var1, FriendlyByteBuf var2);
    }
}

