/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.api.widget.IWidget;
import brachy.modularui.value.sync.IDynamicSyncNotifiable;
import brachy.modularui.value.sync.PanelSyncManager;
import brachy.modularui.value.sync.SyncHandler;
import brachy.modularui.value.sync.ValueSyncHandler;
import brachy.modularui.widget.WidgetTree;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DynamicLinkedSyncHandler<S extends ValueSyncHandler<?>>
extends SyncHandler
implements IDynamicSyncNotifiable {
    private IWidgetProvider<S> widgetProvider;
    private Consumer<IWidget> onWidgetUpdate;
    private boolean updateQueued;
    private IWidget lastRejectedWidget;
    private final S linkedValue;

    public DynamicLinkedSyncHandler(S linkedValue) {
        this.linkedValue = linkedValue;
        ((ValueSyncHandler)linkedValue).setChangeListener(() -> this.notifyUpdate(false));
    }

    @Override
    public void readOnClient(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            this.updateWidget(this.parseWidget());
        }
    }

    @Override
    public void readOnServer(int id, FriendlyByteBuf buf) {
        if (id == 0) {
            this.parseWidget();
        }
    }

    @Override
    public void init(String key, PanelSyncManager syncManager) {
        super.init(key, syncManager);
        if (this.updateQueued) {
            this.notifyUpdate(true);
            this.updateQueued = false;
        }
    }

    private IWidget parseWidget() {
        this.getSyncManager().allowTemporarySyncHandlerRegistration(true);
        IWidget widget = this.widgetProvider.createWidget(this.getSyncManager(), this.linkedValue);
        this.getSyncManager().allowTemporarySyncHandlerRegistration(false);
        int unregistered = WidgetTree.countUnregisteredSyncHandlers(widget);
        if (unregistered > 0) {
            throw new IllegalStateException("Widgets created by DynamicSyncHandler can't have implicitly registered sync handlers. Allsync handlers must be registered with a variant of 'PanelSyncManager#getOrCreateSyncHandler(...)'.");
        }
        return widget;
    }

    private void updateWidget(IWidget widget) {
        if (this.onWidgetUpdate == null) {
            this.lastRejectedWidget = widget;
        } else {
            this.onWidgetUpdate.accept(widget);
        }
    }

    private void notifyUpdate(boolean sync) {
        if (!this.isValid()) {
            this.updateQueued = true;
            return;
        }
        IWidget widget = this.parseWidget();
        if (this.getSyncManager().isClient()) {
            this.updateWidget(widget);
        }
        if (sync) {
            this.sync(0, b -> {});
        }
    }

    public DynamicLinkedSyncHandler<S> widgetProvider(IWidgetProvider<S> widgetProvider) {
        this.widgetProvider = widgetProvider;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public void attachDynamicWidgetListener(Consumer<IWidget> onWidgetUpdate) {
        this.onWidgetUpdate = onWidgetUpdate;
        if (this.onWidgetUpdate != null && this.lastRejectedWidget != null) {
            this.onWidgetUpdate.accept(this.lastRejectedWidget);
            this.lastRejectedWidget = null;
        }
    }

    public static interface IWidgetProvider<S extends ValueSyncHandler<?>> {
        @Nullable
        public IWidget createWidget(PanelSyncManager var1, S var2);
    }
}

