/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value.sync;

import brachy.modularui.api.value.sync.IBoolSyncValue;
import brachy.modularui.value.sync.EnumSyncValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryEnumSyncValue<T extends Enum<T>>
extends EnumSyncValue<T>
implements IBoolSyncValue<T> {
    public BinaryEnumSyncValue(@NotNull Class<T> enumClass, @NotNull Supplier<T> getter, @Nullable Consumer<T> setter) {
        super(enumClass, getter, setter);
        if (((Enum[])enumClass.getEnumConstants()).length != 2) {
            throw new IllegalArgumentException("Enum class must have exactly two elements");
        }
    }

    public BinaryEnumSyncValue(@NotNull Class<T> enumClass, @NotNull Supplier<T> getter) {
        this(enumClass, getter, (Consumer)null);
    }

    @Contract(value="_, null, _, null, _ -> fail")
    public BinaryEnumSyncValue(@NotNull Class<T> enumClass, @Nullable Supplier<T> clientGetter, @Nullable Consumer<T> clientSetter, @Nullable Supplier<T> serverGetter, @Nullable Consumer<T> serverSetter) {
        super(enumClass, clientGetter, clientSetter, serverGetter, serverSetter);
        if (((Enum[])enumClass.getEnumConstants()).length != 2) {
            throw new IllegalArgumentException("Enum class must have exactly two elements");
        }
    }

    @Contract(value="_, null, null -> fail")
    public BinaryEnumSyncValue(@NotNull Class<T> enumClass, @Nullable Supplier<T> clientGetter, @Nullable Supplier<T> serverGetter) {
        this(enumClass, clientGetter, null, serverGetter, null);
    }

    @Override
    public boolean getBoolValue() {
        return this.cache.ordinal() == 1;
    }

    @Override
    public void setBoolValue(boolean value, boolean setSource, boolean sync) {
        this.setValue(((Enum[])this.enumClass.getEnumConstants())[value ? 1 : 0], setSource, sync);
    }
}

