/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.value;

import brachy.modularui.api.value.IEnumValue;
import brachy.modularui.api.value.IIntValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;

public class EnumValue<T extends Enum<T>>
implements IEnumValue<T>,
IIntValue<T> {
    protected final Class<T> enumClass;
    protected T value;

    public static <T extends Enum<T>> Dynamic<T> wrap(IEnumValue<T> val) {
        return new Dynamic<Enum>(val.getEnumClass(), val::getValue, val::setValue);
    }

    public EnumValue(Class<T> enumClass, T value) {
        this.enumClass = enumClass;
        this.value = value;
    }

    @Override
    public int getIntValue() {
        return ((Enum)this.value).ordinal();
    }

    @Override
    public void setIntValue(int val) {
        this.setValue((T)((Enum[])this.enumClass.getEnumConstants())[val]);
    }

    @Override
    public Class<T> getValueType() {
        return this.enumClass;
    }

    @Override
    @Generated
    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    @Override
    @Generated
    public T getValue() {
        return this.value;
    }

    @Override
    @Generated
    public void setValue(T value) {
        this.value = value;
    }

    public static class Dynamic<T extends Enum<T>>
    implements IEnumValue<T>,
    IIntValue<T> {
        protected final Class<T> enumClass;
        protected final Supplier<T> getter;
        protected final Consumer<T> setter;

        public Dynamic(Class<T> enumClass, Supplier<T> getter, Consumer<T> setter) {
            this.enumClass = enumClass;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public int getIntValue() {
            return ((Enum)this.getValue()).ordinal();
        }

        @Override
        public void setIntValue(int val) {
            this.setValue((T)((Enum[])this.enumClass.getEnumConstants())[val]);
        }

        @Override
        public T getValue() {
            return (T)((Enum)this.getter.get());
        }

        @Override
        public void setValue(T value) {
            this.setter.accept(value);
        }

        @Override
        public Class<T> getValueType() {
            return this.enumClass;
        }

        @Override
        @Generated
        public Class<T> getEnumClass() {
            return this.enumClass;
        }
    }
}

