/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils.memoization;

import java.util.function.Supplier;

public class MemoizedSupplier<T>
implements Supplier<T> {
    protected final Supplier<T> delegate;
    protected long timeToLiveNanos;
    protected volatile T value = null;
    private volatile long lastAccessNanos;

    protected MemoizedSupplier(Supplier<T> delegate, long timeToLiveNanos) {
        this.delegate = delegate;
        this.timeToLiveNanos = timeToLiveNanos;
    }

    @Override
    public T get() {
        long now = System.nanoTime();
        if (this.lastAccessNanos == 0L || this.timeToLiveNanos >= 0L && now - this.lastAccessNanos >= this.timeToLiveNanos) {
            this.value = this.delegate.get();
        }
        this.lastAccessNanos = now;
        return this.value;
    }

    public void invalidate() {
        this.lastAccessNanos = 0L;
        this.value = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.lastAccessNanos != 0L ? this.value : "Uninitialized") + ")";
    }
}

