/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class SpriteHelper {
    public static TextureAtlasSprite getSpriteOfBlockState(BlockState blockState, Direction facing) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(blockState);
        return SpriteHelper.getBestTexture(model, blockState, facing);
    }

    public static List<BakedQuad> getQuadsOfBlockState(BlockState blockState, Direction facing) {
        return Minecraft.m_91087_().m_91289_().m_110910_(blockState).getQuads(blockState, facing, RandomSource.m_216327_(), ModelData.EMPTY, null);
    }

    public static TextureAtlasSprite getBestTexture(BakedModel model, @Nullable BlockState blockState, @Nullable Direction facing) {
        List quads = model.getQuads(blockState, facing, RandomSource.m_216327_(), ModelData.EMPTY, null);
        if (quads.isEmpty()) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
        }
        return ((BakedQuad)quads.get(0)).m_173410_();
    }

    public static TextureAtlasSprite getSpriteOfItem(ItemStack item) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(item, null, null, 0);
        return SpriteHelper.getBestTexture(model, null, null);
    }

    public static List<BakedQuad> getQuadsOfItem(ItemStack item) {
        return Minecraft.m_91087_().m_91291_().m_174264_(item, null, null, 0).getQuads(null, null, RandomSource.m_216327_(), ModelData.EMPTY, null);
    }
}

