/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.utils.Point;
import brachy.modularui.utils.PointF;
import lombok.Generated;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(Rectangle toCopy) {
        this(toCopy.x, toCopy.y, toCopy.width, toCopy.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle intersect(Rectangle other) {
        int i = this.x;
        int j = this.y;
        int k = this.x + this.width;
        int l = this.y + this.height;
        int i1 = other.getX();
        int j1 = other.getY();
        int k1 = i1 + other.getWidth();
        int l1 = j1 + other.getHeight();
        this.x = Math.max(i, i1);
        this.y = Math.max(j, j1);
        this.width = Math.max(0, Math.min(k, k1) - this.x);
        this.height = Math.max(0, Math.min(l, l1) - this.y);
        return this;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setBounds(Rectangle toCopy) {
        this.setBounds(toCopy.x, toCopy.y, toCopy.width, toCopy.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public PointF getCenter() {
        return new PointF((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rect2i asRect2i() {
        return new Rect2i(this.x, this.y, this.width, this.height);
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public void setX(int x) {
        this.x = x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public void setY(int y) {
        this.y = y;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public void setWidth(int width) {
        this.width = width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public void setHeight(int height) {
        this.height = height;
    }
}

