/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MutableSingletonList<T>
implements List<T> {
    private boolean hasValue;
    private T value;

    public MutableSingletonList() {
        this.remove();
    }

    public MutableSingletonList(T value) {
        this.set(value);
    }

    public T get() {
        if (!this.hasValue) {
            throw new IndexOutOfBoundsException("List is empty but tried to access index 0!");
        }
        return this.value;
    }

    public T getOrNull() {
        return this.hasValue ? (T)this.value : null;
    }

    public void set(T t) {
        this.value = t;
        this.hasValue = true;
    }

    public void remove() {
        this.value = null;
        this.hasValue = false;
    }

    @Override
    public int size() {
        return this.hasValue ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasValue;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public boolean contains(Object o) {
        return this.hasValue && Objects.equals(this.value, o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private byte cursor = 0;

            @Override
            public boolean hasNext() {
                return MutableSingletonList.this.hasValue && this.cursor == 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cursor = (byte)(this.cursor + 1);
                return MutableSingletonList.this.value;
            }

            @Override
            public void remove() {
                if (this.cursor < 1) {
                    throw new IllegalStateException();
                }
                MutableSingletonList.this.remove();
                this.cursor = (byte)(this.cursor - 1);
            }
        };
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        if (!this.hasValue) {
            return new Object[0];
        }
        Object[] o = new Object[]{this.value};
        return o;
    }

    @Override
    @NotNull
    public <T1> @NotNull T1 @NotNull [] toArray(@NotNull @NotNull T1 @NotNull [] a) {
        if (!this.hasValue) {
            return a;
        }
        if (a.length == 0) {
            a = Arrays.copyOf(a, 1);
        }
        a[0] = this.value;
        return a;
    }

    @Override
    public boolean add(T t) {
        if (this.hasValue) {
            throw new IllegalStateException("MutableSingletonList can only have one value, but it already has a value!");
        }
        this.set(t);
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            this.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        int s = c.size();
        if (s > 1 || s == 1 != this.hasValue) {
            return false;
        }
        if (!this.hasValue) {
            return true;
        }
        if (c instanceof List) {
            List l = (List)c;
            return Objects.equals(this.value, l.get(0));
        }
        return Objects.equals(this.value, c.iterator().next());
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (this.hasValue || c.isEmpty()) {
            return false;
        }
        if (c instanceof List) {
            List l = (List)c;
            this.add((T)l.get(0));
        } else {
            this.add(c.iterator().next());
        }
        return true;
    }

    private void verifyIndex(int i, boolean checkEmpty) {
        if (i != 0) {
            throw new IndexOutOfBoundsException("MutableSingletonList only accepts index 0!");
        }
        if (checkEmpty && !this.hasValue) {
            throw new IndexOutOfBoundsException("Tried to access index 0, but MutableSingletonList has no element!");
        }
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        this.verifyIndex(index, false);
        return this.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (!this.hasValue || c.isEmpty()) {
            return false;
        }
        if (c instanceof List) {
            List l = (List)c;
            return this.remove(l.get(0));
        }
        return this.remove(c.iterator().next());
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (!this.hasValue || c.contains(this.value)) {
            return false;
        }
        this.remove();
        return true;
    }

    @Override
    public void clear() {
        this.remove();
    }

    @Override
    public T get(int index) {
        this.verifyIndex(index, true);
        return null;
    }

    @Override
    public T set(int index, T element) {
        this.verifyIndex(index, true);
        T t = this.value;
        this.value = element;
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.verifyIndex(index, false);
        this.add(element);
    }

    @Override
    public T remove(int index) {
        this.verifyIndex(index, true);
        T t = this.value;
        this.remove();
        return t;
    }

    @Override
    public int indexOf(Object o) {
        return this.contains(o) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new ListIterator<T>(){
            private byte cursor = 0;

            @Override
            public boolean hasNext() {
                return MutableSingletonList.this.hasValue && (this.cursor == 0 || this.cursor == -1);
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cursor = 1;
                return MutableSingletonList.this.value;
            }

            @Override
            public boolean hasPrevious() {
                return MutableSingletonList.this.hasValue && (this.cursor == 0 || this.cursor == 1);
            }

            @Override
            public T previous() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cursor = (byte)-1;
                return MutableSingletonList.this.value;
            }

            @Override
            public int nextIndex() {
                return this.cursor == 0 ? 0 : 1;
            }

            @Override
            public int previousIndex() {
                return this.cursor == 0 ? 0 : -1;
            }

            @Override
            public void remove() {
                if (this.cursor == 0) {
                    throw new IllegalStateException();
                }
                MutableSingletonList.this.remove();
                this.cursor = 0;
            }

            @Override
            public void set(T t) {
                if (this.cursor == 0) {
                    throw new IllegalStateException();
                }
                MutableSingletonList.this.set(t);
            }

            @Override
            public void add(T t) {
                MutableSingletonList.this.add(t);
            }
        };
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        this.verifyIndex(index, false);
        return this.listIterator();
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > 1 || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new MutableSingletonList<T>(this.value);
    }
}

