/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.api.widget.Interactable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record MouseData(Dist side, int mouseButton, boolean shift, boolean ctrl, boolean alt) {
    public boolean isClient() {
        return this.side.isClient();
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.mouseButton);
        byte data = 0;
        if (this.shift) {
            data = (byte)(data | 1);
        }
        if (this.ctrl) {
            data = (byte)(data | 2);
        }
        if (this.alt) {
            data = (byte)(data | 4);
        }
        buffer.writeByte((int)data);
    }

    public static MouseData readPacket(FriendlyByteBuf buffer) {
        int button = buffer.m_130242_();
        byte data = buffer.readByte();
        return new MouseData(Dist.DEDICATED_SERVER, button, (data & 1) != 0, (data & 2) != 0, (data & 4) != 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MouseData create(int mouse) {
        return new MouseData(Dist.CLIENT, mouse, Interactable.hasShiftDown(), Interactable.hasControlDown(), Interactable.hasAltDown());
    }
}

