/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import brachy.modularui.ModularUI;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class ImageUtil {
    private static final List<ImageType> TYPES = new ArrayList<ImageType>();
    private static final byte[] buffer = new byte[256];
    public static final long ERROR_NO_RESOURCE = -1L;
    public static final long ERROR_NO_IMAGE_TYPE = -2L;
    public static final long ERROR_IO_EXCEPTION = -3L;
    public static final long ERROR_PNG = -4L;
    public static final long ERROR_JPEG_1 = -5L;
    public static final long ERROR_JPEG_2 = -6L;
    private static final String[] ERROR_MSG = new String[]{"Resource not found", "Unsupported file type", "Failed to parse image with unknown cause", "PNG file ended too early", "JPEG started again within itself", "JPEG ended too early"};

    public static Resource getResource(ResourceLocation resLoc) {
        try {
            return Minecraft.m_91087_().m_91098_().m_215593_(resLoc);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static long readImageSize(ResourceLocation resLoc) {
        Resource res = ImageUtil.getResource(resLoc);
        return res == null ? -1L : ImageUtil.readImageSize(res);
    }

    public static String getError(long size) {
        return size < 0L ? ERROR_MSG[(int)(-size - 1L)] : null;
    }

    public static long readImageSize(Resource resource) {
        long l;
        block8: {
            InputStream inputStream = resource.m_215507_();
            try {
                l = ImageUtil.readImageSize(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return -3L;
                }
            }
            inputStream.close();
        }
        return l;
    }

    public static long readImageSize(InputStream inputStream) throws IOException {
        ImageType type = ImageUtil.parseImageType(inputStream);
        return type == null ? -2L : type.parse(inputStream);
    }

    public static long packSize(int width, int height) {
        return (long)width | (long)height << 32;
    }

    public static int getWidth(long packedSize) {
        return (int)(packedSize & 0xFFFFFFFFL);
    }

    public static int getHeight(long packedSize) {
        return (int)(packedSize >> 32 & 0xFFFFFFFFL);
    }

    public static boolean testImageSize(ResourceLocation resLoc, int width, int height) {
        long size = ImageUtil.readImageSize(resLoc);
        if (size < 0L) {
            ModularUI.LOGGER.error("{} for location '{}'", (Object)ImageUtil.getError(size), (Object)resLoc);
            return false;
        }
        int w = ImageUtil.getWidth(size);
        int h = ImageUtil.getHeight(size);
        if (w != width || h != height) {
            ModularUI.LOGGER.error("Image size is incorrect of image '{}'. Expected {}|{}, but actually is {}|{}", (Object)resLoc, (Object)width, (Object)height, (Object)w, (Object)h);
        } else {
            ModularUI.LOGGER.info("Image '{}' has correct size", (Object)resLoc);
        }
        return true;
    }

    private static ImageType parseImageType(InputStream inputStream) throws IOException {
        if (TYPES.isEmpty()) {
            ImageUtil.initImageTypes();
        }
        int bytesRead = 0;
        for (ImageType type : TYPES) {
            while (type.signatureLength > bytesRead) {
                ImageUtil.buffer[bytesRead] = (byte)inputStream.read();
                ++bytesRead;
            }
            if (!ImageUtil.startsWith(buffer, bytesRead, type.signatureStart)) continue;
            return type;
        }
        return null;
    }

    public static String getImageType(InputStream inputStream) {
        try {
            ImageType type = ImageUtil.parseImageType(inputStream);
            return type == null ? null : type.name();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void initImageTypes() {
        TYPES.clear();
        ImageType[] types = ImageType.values();
        TYPES.add(types[0]);
        block0: for (int i = 1; i < types.length; ++i) {
            for (int j = 0; j < TYPES.size(); ++j) {
                if (ImageUtil.TYPES.get((int)j).signatureLength <= types[i].signatureLength) continue;
                TYPES.add(j, types[i]);
                continue block0;
            }
        }
    }

    public static DataInput getDataInput(InputStream is) {
        DataInput dataInput;
        if (is instanceof DataInput) {
            DataInput dataInput2 = (DataInput)((Object)is);
            dataInput = dataInput2;
        } else {
            dataInput = new DataInputStream(is);
        }
        return dataInput;
    }

    public static byte[] toBytes(int ... ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)(ints[i] & 0xFF);
        }
        return bytes;
    }

    private static boolean startsWith(byte[] bytes, int bytesLen, byte[] startsWith) {
        if (startsWith.length > bytesLen) {
            return false;
        }
        for (int i = 0; i < startsWith.length; ++i) {
            if (startsWith[i] == bytes[i]) continue;
            return false;
        }
        return true;
    }

    public static String getFileTypeOfPath(String path) {
        int i = path.lastIndexOf(46);
        return i < 0 || i == path.length() - 1 ? null : path.substring(i + 1);
    }

    public static int readLittleEndianShort(InputStream inputStream) throws IOException {
        return inputStream.read() & 0xFF | (inputStream.read() & 0xFF) << 8;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ImageType implements SizeParser
    {
        PNG(8, new int[]{137, 80, 78, 71, 13, 10, 26, 10}){

            @Override
            public long parse(InputStream inputStream) throws IOException {
                DataInput dataInput = ImageUtil.getDataInput(inputStream);
                int skipped = dataInput.skipBytes(8);
                if (skipped != 8) {
                    return -4L;
                }
                return ImageUtil.packSize(dataInput.readInt(), dataInput.readInt());
            }
        }
        ,
        JPEG(2, new int[]{255, 216}){

            @Override
            public long parse(InputStream inputStream) throws IOException {
                DataInput dis = ImageUtil.getDataInput(inputStream);
                while (true) {
                    int marker = dis.readUnsignedShort();
                    while (marker == 65535) {
                        marker = dis.readUnsignedByte();
                    }
                    if (marker >= 65472 && marker <= 65475 || marker >= 65477 && marker <= 65479 || marker >= 65481 && marker <= 65483 || marker >= 65485 && marker <= 65487) {
                        dis.readUnsignedShort();
                        dis.readUnsignedByte();
                        int height = dis.readUnsignedShort();
                        int width = dis.readUnsignedShort();
                        return ImageUtil.packSize(width, height);
                    }
                    if (marker == 65496) {
                        return -5L;
                    }
                    if (marker == 65497) {
                        return -6L;
                    }
                    if (marker >= 65488 && marker <= 65495 || marker == 65281) continue;
                    int len = dis.readUnsignedShort();
                    dis.skipBytes(len - 2);
                }
            }
        }
        ,
        GIF(6, new int[]{71, 73, 70, 56}){

            @Override
            public long parse(InputStream inputStream) throws IOException {
                return ImageUtil.packSize(ImageUtil.readLittleEndianShort(inputStream), ImageUtil.readLittleEndianShort(inputStream));
            }
        };

        private final int signatureLength;
        private final byte[] signatureStart;

        private ImageType(int signatureLength, int ... signatureStart) {
            this.signatureLength = signatureLength;
            this.signatureStart = ImageUtil.toBytes(signatureStart);
        }
    }

    private static interface SizeParser {
        public long parse(InputStream var1) throws IOException;
    }
}

