/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public enum FluidTextureType {
    STILL((fluidTypeExtensions, fluidStack) -> {
        if (!fluidStack.isEmpty()) {
            return fluidTypeExtensions.getStillTexture(fluidStack);
        }
        return fluidTypeExtensions.getStillTexture();
    }),
    FLOWING((fluidTypeExtensions, fluidStack) -> {
        if (!fluidStack.isEmpty()) {
            return fluidTypeExtensions.getFlowingTexture(fluidStack);
        }
        return fluidTypeExtensions.getFlowingTexture();
    }),
    OVERLAY((fluidTypeExtensions, fluidStack) -> {
        if (!fluidStack.isEmpty()) {
            return fluidTypeExtensions.getOverlayTexture(fluidStack);
        }
        return fluidTypeExtensions.getOverlayTexture();
    });

    private static final ResourceLocation WATER_STILL;
    private final BiFunction<IClientFluidTypeExtensions, FluidStack, ResourceLocation> mapper;

    private FluidTextureType(BiFunction<IClientFluidTypeExtensions, FluidStack, ResourceLocation> mapper) {
        this.mapper = mapper;
    }

    public TextureAtlasSprite map(IClientFluidTypeExtensions fluidTypeExtensions) {
        return this.map(fluidTypeExtensions, FluidStack.EMPTY);
    }

    public TextureAtlasSprite map(IClientFluidTypeExtensions fluidTypeExtensions, FluidStack fluidStack) {
        ResourceLocation texture = this.mapper.apply(fluidTypeExtensions, fluidStack);
        if (texture == null) {
            texture = FluidTextureType.STILL.mapper.apply(fluidTypeExtensions, fluidStack);
        }
        if (texture == null) {
            texture = WATER_STILL;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
    }

    static {
        WATER_STILL = new ResourceLocation("minecraft", "block/water_still");
    }
}

