/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidTankHandler
implements IFluidHandler {
    private final IFluidTank fluidTank;

    public static IFluidHandler getTankFluidHandler(IFluidTank tank) {
        if (tank instanceof IFluidHandler) {
            IFluidHandler fluidHandler = (IFluidHandler)tank;
            return fluidHandler;
        }
        return new FluidTankHandler(tank);
    }

    public FluidTankHandler(IFluidTank tank) {
        this.fluidTank = tank;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fluidTank.fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid.isEmpty() || !currentFluid.isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.fluidTank.drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.fluidTank.drain(maxDrain, action);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidTank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidTank.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.fluidTank.isFluidValid(stack);
    }
}

