/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import java.util.Arrays;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FAM {
    public static final float[] EMPTY = new float[0];

    public static float[] zeros(int n) {
        return new float[n];
    }

    public static float[] full(int n, float f) {
        float[] arr = new float[n];
        Arrays.fill(arr, f);
        return arr;
    }

    public static float[] ones(int n) {
        return FAM.full(n, 1.0f);
    }

    public static float[] copyInto(float[] src, float @Nullable [] res) {
        if (src == res) {
            return res;
        }
        if (res == null) {
            res = new float[src.length];
        }
        int n = Math.min(src.length, res.length);
        System.arraycopy(src, 0, res, 0, n);
        return res;
    }

    public static float[] subArray(float[] src, int start, int length) {
        float[] res = new float[length];
        System.arraycopy(src, start, res, 0, length);
        return res;
    }

    public static float[] linspace(float start, float stop) {
        return FAM.linspace(start, stop, 50, true);
    }

    public static float[] linspace(float start, float stop, boolean includeEndpoint) {
        return FAM.linspace(start, stop, 50, includeEndpoint);
    }

    public static float[] linspace(float start, float stop, int n) {
        return FAM.linspace(start, stop, n, true);
    }

    public static float[] linspace(float start, float stop, int n, boolean includeEndpoint) {
        float[] arr = new float[n];
        float step = (stop - start) / (float)(includeEndpoint ? n + 1 : n);
        int s = n;
        if (includeEndpoint) {
            arr[n - 1] = stop;
            --s;
        }
        for (int i = 0; i < s; ++i) {
            arr[i] = start + step * (float)i;
        }
        return arr;
    }

    public static float[] arange(float stop, float step) {
        return FAM.arange(0.0f, stop, step);
    }

    public static float[] arange(float start, float stop, float step) {
        float[] arr = new float[(int)Math.ceil((stop - start) / step)];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = start + step * (float)i;
        }
        return arr;
    }

    public static int argMax(float[] arr) {
        if (arr.length == 0) {
            return -1;
        }
        if (arr.length == 1) {
            return 0;
        }
        if (arr.length == 2) {
            return arr[0] >= arr[1] ? 0 : 1;
        }
        int index = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > arr[index])) continue;
            index = i;
        }
        return index;
    }

    public static int argMin(float[] arr) {
        if (arr.length == 0) {
            return -1;
        }
        if (arr.length == 1) {
            return 0;
        }
        if (arr.length == 2) {
            return arr[0] <= arr[1] ? 0 : 1;
        }
        int index = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] < arr[index])) continue;
            index = i;
        }
        return index;
    }

    public static float max(float[] arr) {
        int i = FAM.argMax(arr);
        return i < 0 ? 0.0f : arr[i];
    }

    public static float min(float[] arr) {
        int i = FAM.argMin(arr);
        return i < 0 ? 0.0f : arr[i];
    }

    public static float[] plus(float[] src, float op, float @Nullable [] res) {
        return FAM.applyEach(src, v -> v + op, res);
    }

    public static float[] plus(float[] src, float[] op, float @Nullable [] res) {
        return FAM.applyEach(src, op, Float::sum, res);
    }

    public static float[] mult(float[] src, float op, float @Nullable [] res) {
        return FAM.applyEach(src, v -> v * op, res);
    }

    public static float[] mult(float[] src, float[] op, float @Nullable [] res) {
        return FAM.applyEach(src, op, (float v, float op1) -> v * op1, res);
    }

    public static float[] div(float[] src, float op, float @Nullable [] res) {
        return FAM.mult(src, 1.0f / op, res);
    }

    public static float[] div(float[] src, float[] op, float @Nullable [] res) {
        return FAM.applyEach(src, op, (float v, float op1) -> v / op1, res);
    }

    public static float[] diff(float[] src) {
        if (src.length < 2) {
            return EMPTY;
        }
        if (src.length == 2) {
            return new float[]{src[1] - src[0]};
        }
        float[] res = new float[src.length - 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = src[i + 1] - src[i];
        }
        return res;
    }

    public static float[] applyEach(float[] src, UnaryFloatOperator op, float @Nullable [] res) {
        if (res == null) {
            res = new float[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i]);
        }
        return res;
    }

    public static float[] applyEach(float[] src, float[] operands, BinaryFloatOperator op, float @Nullable [] res) {
        if (src.length != operands.length) {
            throw new IllegalArgumentException("Can't apply operator to operands of different size.");
        }
        if (res == null) {
            res = new float[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i], operands[i]);
        }
        return res;
    }

    public static float[] applyEach(float[] src, float[] operands1, float[] operands2, TernaryFloatOperator op, float @Nullable [] res) {
        if (src.length != operands1.length || src.length != operands2.length) {
            throw new IllegalArgumentException("Can't apply operator to operands of different size.");
        }
        if (res == null) {
            res = new float[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i], operands1[i], operands2[i]);
        }
        return res;
    }

    public static float[] applyEach(float[] src, float[][] operands, NFloatOperator op, float @Nullable [] res) {
        if (src.length != operands.length) {
            throw new IllegalArgumentException("Can't apply operator to operands of different size.");
        }
        if (res == null) {
            res = new float[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i], operands[i]);
        }
        return res;
    }

    public static float[] abs(float[] src, float @Nullable [] res) {
        return FAM.applyEach(src, Math::abs, res);
    }

    public static float[] sin(float[] src, float @Nullable [] res) {
        return FAM.applyEach(src, Mth::m_14031_, res);
    }

    public static float[] cos(float[] src, float @Nullable [] res) {
        return FAM.applyEach(src, Mth::m_14089_, res);
    }

    public static float[] tan(float[] src, float @Nullable [] res) {
        return FAM.applyEach(src, r -> (float)Math.tan(r), res);
    }

    public static float[] clamp(float[] src, float min, float max, float @Nullable [] res) {
        return FAM.applyEach(src, v -> Mth.m_14036_((float)v, (float)min, (float)max), res);
    }

    public static float[] polynomial(float[] src, float[] coeff, float @Nullable [] res) {
        if (coeff.length == 0) {
            return FAM.copyInto(src, res);
        }
        if (coeff.length == 1) {
            return FAM.plus(src, coeff[0], res);
        }
        return FAM.applyEach(src, x -> {
            float y = 0.0f;
            y += coeff[0];
            if (coeff.length == 2) {
                return y + x * coeff[1];
            }
            for (int i = 1; i < coeff.length; ++i) {
                y += (float)(Math.pow(x, i) * (double)coeff[i]);
            }
            return y;
        }, res);
    }

    public static interface UnaryFloatOperator {
        public float apply(float var1);
    }

    public static interface BinaryFloatOperator {
        public float apply(float var1, float var2);
    }

    public static interface TernaryFloatOperator {
        public float apply(float var1, float var2, float var3);
    }

    public static interface NFloatOperator {
        public float apply(float var1, float[] var2);
    }
}

