/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface EqualityTest<T> {
    public boolean areEqual(@NotNull T var1, @NotNull T var2);

    public static <T> EqualityTest<T> wrapNullSafe(EqualityTest<T> equals) {
        return (t1, t2) -> {
            if (t1 == null || t2 == null) {
                return t1 == t2;
            }
            return equals.areEqual(t1, t2);
        };
    }

    public static <T> EqualityTest<T> defaultTester() {
        return Objects::equals;
    }
}

