/*
 * Decompiled with CFR 0.152.
 */
package brachy.modularui.utils;

import java.util.Arrays;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class DAM {
    public static final double[] EMPTY = new double[0];

    public static double[] zeros(int n) {
        return new double[n];
    }

    public static double[] full(int n, double f) {
        double[] arr = new double[n];
        Arrays.fill(arr, f);
        return arr;
    }

    public static double[] ones(int n) {
        return DAM.full(n, 1.0);
    }

    public static double[] copyInto(double[] src, double @Nullable [] res) {
        if (src == res) {
            return res;
        }
        if (res == null) {
            res = new double[src.length];
        }
        int n = Math.min(src.length, res.length);
        System.arraycopy(src, 0, res, 0, n);
        return res;
    }

    public static double[] subArray(double[] src, int start, int length) {
        double[] res = new double[length];
        System.arraycopy(src, start, res, 0, length);
        return res;
    }

    public static double[] ofFloats(float[] src) {
        double[] res = new double[src.length];
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[i];
        }
        return res;
    }

    public static double[] ofInts(int[] src) {
        double[] res = new double[src.length];
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[i];
        }
        return res;
    }

    public static double[] ofLongs(long[] src) {
        double[] res = new double[src.length];
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[i];
        }
        return res;
    }

    public static double[] linspace(double start, double stop) {
        return DAM.linspace(start, stop, 50, true);
    }

    public static double[] linspace(double start, double stop, boolean includeEndpoint) {
        return DAM.linspace(start, stop, 50, includeEndpoint);
    }

    public static double[] linspace(double start, double stop, int n) {
        return DAM.linspace(start, stop, n, true);
    }

    public static double[] linspace(double start, double stop, int n, boolean includeEndpoint) {
        double[] arr = new double[n];
        double step = (stop - start) / (double)(includeEndpoint ? n + 1 : n);
        int s = n;
        if (includeEndpoint) {
            arr[n - 1] = stop;
            --s;
        }
        for (int i = 0; i < s; ++i) {
            arr[i] = start + step * (double)i;
        }
        return arr;
    }

    public static double[] arange(double stop, double step) {
        return DAM.arange(0.0, stop, step);
    }

    public static double[] arange(double start, double stop, double step) {
        double[] arr = new double[(int)Math.ceil((stop - start) / step)];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = start + step * (double)i;
        }
        return arr;
    }

    public static int argMax(double[] arr) {
        if (arr.length == 0) {
            return -1;
        }
        if (arr.length == 1) {
            return 0;
        }
        if (arr.length == 2) {
            return arr[0] >= arr[1] ? 0 : 1;
        }
        int index = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > arr[index])) continue;
            index = i;
        }
        return index;
    }

    public static int argMin(double[] arr) {
        if (arr.length == 0) {
            return -1;
        }
        if (arr.length == 1) {
            return 0;
        }
        if (arr.length == 2) {
            return arr[0] <= arr[1] ? 0 : 1;
        }
        int index = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] < arr[index])) continue;
            index = i;
        }
        return index;
    }

    public static double max(double[] arr) {
        int i = DAM.argMax(arr);
        return i < 0 ? 0.0 : arr[i];
    }

    public static double min(double[] arr) {
        int i = DAM.argMin(arr);
        return i < 0 ? 0.0 : arr[i];
    }

    public static double[] plus(double[] src, double op, double @Nullable [] res) {
        return DAM.applyEach(src, v -> v + op, res);
    }

    public static double[] plusMut(double[] src, double op) {
        return DAM.plus(src, op, src);
    }

    public static double[] plus(double[] src, double[] op, double @Nullable [] res) {
        return DAM.applyEach(src, op, Double::sum, res);
    }

    public static double[] plusMut(double[] src, double[] op) {
        return DAM.plus(src, op, src);
    }

    public static double[] mult(double[] src, double op, double @Nullable [] res) {
        return DAM.applyEach(src, v -> v * op, res);
    }

    public static double[] multMut(double[] src, double op) {
        return DAM.mult(src, op, src);
    }

    public static double[] mult(double[] src, double[] op, double @Nullable [] res) {
        return DAM.applyEach(src, op, (double v, double op1) -> v * op1, res);
    }

    public static double[] multMut(double[] src, double[] op) {
        return DAM.mult(src, op, src);
    }

    public static double[] div(double[] src, double op, double @Nullable [] res) {
        return DAM.mult(src, 1.0 / op, res);
    }

    public static double[] divMut(double[] src, double op) {
        return DAM.div(src, op, src);
    }

    public static double[] div(double[] src, double[] op, double @Nullable [] res) {
        return DAM.applyEach(src, op, (double v, double op1) -> v / op1, res);
    }

    public static double[] divMut(double[] src, double[] op) {
        return DAM.div(src, op, src);
    }

    public static double[] reciprocal(double a, double[] b, double @Nullable [] res) {
        return DAM.applyEach(b, v -> a / v, res);
    }

    public static double[] square(double[] src, double @Nullable [] res) {
        return DAM.applyEach(src, v -> v * v, res);
    }

    public static double[] cube(double[] src, double @Nullable [] res) {
        return DAM.applyEach(src, v -> v * v * v, res);
    }

    public static double[] pow(double[] src, double op, double @Nullable [] res) {
        return DAM.applyEach(src, v -> Math.pow(v, op), res);
    }

    public static double[] diff(double[] src) {
        if (src.length < 2) {
            return EMPTY;
        }
        if (src.length == 2) {
            return new double[]{src[1] - src[0]};
        }
        double[] res = new double[src.length - 1];
        for (int i = 0; i < res.length; ++i) {
            res[i] = src[i + 1] - src[i];
        }
        return res;
    }

    public static double[] applyEach(double[] src, UnaryDoubleOperator op, double @Nullable [] res) {
        if (res == null) {
            res = new double[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i]);
        }
        return res;
    }

    public static double[] applyEach(double[] src, double[] operands, BinaryDoubleOperator op, double @Nullable [] res) {
        if (src.length != operands.length) {
            throw new IllegalArgumentException("Can't apply operator to operands of different size.");
        }
        if (res == null) {
            res = new double[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i], operands[i]);
        }
        return res;
    }

    public static double[] applyEach(double[] src, double[] operands1, double[] operands2, TernaryDoubleOperator op, double @Nullable [] res) {
        if (src.length != operands1.length || src.length != operands2.length) {
            throw new IllegalArgumentException("Can't apply operator to operands of different size.");
        }
        if (res == null) {
            res = new double[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i], operands1[i], operands2[i]);
        }
        return res;
    }

    public static double[] applyEach(double[] src, double[][] operands, NDoubleOperator op, double @Nullable [] res) {
        if (src.length != operands.length) {
            throw new IllegalArgumentException("Can't apply operator to operands of different size.");
        }
        if (res == null) {
            res = new double[src.length];
        }
        int n = Math.min(src.length, res.length);
        for (int i = 0; i < n; ++i) {
            res[i] = op.apply(src[i], operands[i]);
        }
        return res;
    }

    public static double[] abs(double[] src, double @Nullable [] res) {
        return DAM.applyEach(src, Math::abs, res);
    }

    public static double[] sin(double[] src, double @Nullable [] res) {
        return DAM.applyEach(src, Math::sin, res);
    }

    public static double[] cos(double[] src, double @Nullable [] res) {
        return DAM.applyEach(src, Math::cos, res);
    }

    public static double[] tan(double[] src, double @Nullable [] res) {
        return DAM.applyEach(src, Math::tan, res);
    }

    public static double[] clamp(double[] src, double min, double max, double @Nullable [] res) {
        return DAM.applyEach(src, v -> Mth.m_14008_((double)v, (double)min, (double)max), res);
    }

    public static double[] polynomial(double[] src, double[] coeff, double @Nullable [] res) {
        if (coeff.length == 0) {
            return DAM.copyInto(src, res);
        }
        if (coeff.length == 1) {
            return DAM.plus(src, coeff[0], res);
        }
        return DAM.applyEach(src, x -> {
            double y = 0.0;
            y += coeff[0];
            if (coeff.length == 2) {
                return y + x * coeff[1];
            }
            for (int i = 1; i < coeff.length; ++i) {
                y += Math.pow(x, i) * coeff[i];
            }
            return y;
        }, res);
    }

    public static double reduce(double[] src, BinaryDoubleOperator op) {
        if (src.length == 0) {
            return 0.0;
        }
        if (src.length == 1) {
            return src[0];
        }
        double res = op.apply(src[0], src[1]);
        if (src.length == 2) {
            return res;
        }
        for (int i = 2; i < src.length; ++i) {
            res = op.apply(res, src[i]);
        }
        return res;
    }

    public static double[] reverse(double[] src, double @Nullable [] res) {
        if (res == null) {
            res = new double[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[src.length - i - 1];
        }
        return res;
    }

    public static double sum(double[] src) {
        return DAM.reduce(src, Double::sum);
    }

    public static double product(double[] src) {
        return DAM.reduce(src, (f1, f2) -> f1 * f2);
    }

    public static double arithmeticMean(double[] src) {
        return DAM.sum(src) / (double)src.length;
    }

    public static double geometricMean(double[] src) {
        return Math.pow(DAM.product(src), 1.0f / (float)src.length);
    }

    public static double[] concat(double[] a, double[] b) {
        double[] res = new double[a.length + b.length];
        System.arraycopy(a, 0, res, 0, a.length);
        System.arraycopy(b, 0, res, a.length, b.length);
        return res;
    }

    public static double[] flatten(double[] ... src) {
        if (src.length == 0) {
            return EMPTY;
        }
        if (src.length == 1) {
            return src[0];
        }
        if (src.length == 2) {
            return DAM.concat(src[0], src[1]);
        }
        int n = 0;
        for (double[] doubles : src) {
            n += doubles.length;
        }
        if (n == 0) {
            return EMPTY;
        }
        double[] res = new double[n];
        n = 0;
        for (double[] doubles : src) {
            System.arraycopy(doubles, 0, res, n, doubles.length);
            n += doubles.length;
        }
        return res;
    }

    public static interface UnaryDoubleOperator {
        public double apply(double var1);
    }

    public static interface BinaryDoubleOperator {
        public double apply(double var1, double var3);
    }

    public static interface TernaryDoubleOperator {
        public double apply(double var1, double var3, double var5);
    }

    public static interface NDoubleOperator {
        public double apply(double var1, double[] var3);
    }
}

